/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.structure;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;

public class StructureSettingsCache {
    private static final Map<DimensionStructuresSettings, DimensionStructuresSettings> CACHE = new ConcurrentHashMap<DimensionStructuresSettings, DimensionStructuresSettings>();

    public static DimensionStructuresSettings get(DimensionStructuresSettings settings) {
        return CACHE.compute(settings, (key, value) -> {
            if (value == null) {
                return StructureSettingsCache.clone(key);
            }
            if (key.func_236199_b_() != value.func_236199_b_()) {
                return StructureSettingsCache.clone(key);
            }
            if (key.func_236195_a_() != value.func_236195_a_()) {
                return StructureSettingsCache.clone(key);
            }
            return value;
        });
    }

    public static void clear() {
        CACHE.clear();
    }

    private static DimensionStructuresSettings clone(DimensionStructuresSettings settings) {
        return new DimensionStructuresSettings(Optional.ofNullable(settings.func_236199_b_()), (Map)ImmutableMap.copyOf((Map)settings.func_236195_a_()));
    }
}

