/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.profiler.timings;

import com.terraforged.mod.profiler.timings.TimingStack;

public class RollingTimingsStack
implements TimingStack {
    private final Entry[] entries = new Entry[16];
    private int index = -1;
    private int size = 0;

    public RollingTimingsStack() {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = new Entry();
        }
    }

    private RollingTimingsStack(RollingTimingsStack other) {
        this.index = other.index;
        this.size = other.size;
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = other.entries[i].copy();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public RollingTimingsStack copy() {
        return new RollingTimingsStack(this);
    }

    @Override
    public RollingTimingsStack reset() {
        this.index = -1;
        this.size = 0;
        for (Entry entry : this.entries) {
            entry.reset();
        }
        return this;
    }

    @Override
    public void push(String type, Object identifier, long time) {
        this.entries[this.nextIndex()].set(type, identifier, time);
        this.size = Math.min(this.entries.length, this.size + 1);
    }

    @Override
    public <T> void iterate(T ctx, TimingStack.Visitor<T> consumer) {
        int offset = 1 + this.index - this.size & 0xF;
        for (int i = this.size - 1; i >= 0; --i) {
            int index = offset + i & 0xF;
            Entry entry = this.entries[index];
            if (entry.empty()) continue;
            consumer.visit(entry.type, entry.identifier, entry.time, ctx);
        }
    }

    private int nextIndex() {
        this.index = this.index + 1 & 0xF;
        return this.index;
    }

    private static class Entry {
        private String type = null;
        private Object identifier = null;
        private long time = 0L;

        private Entry() {
        }

        private boolean empty() {
            return this.type == null && this.identifier == null;
        }

        private void reset() {
            this.type = null;
            this.identifier = null;
            this.time = 0L;
        }

        private void set(String type, Object identifier, long time) {
            this.identifier = identifier;
            this.type = type;
            this.time = time;
        }

        private Entry copy() {
            Entry entry = new Entry();
            entry.set(this.type, this.identifier, this.time);
            return entry;
        }
    }
}

