/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.profiler;

import com.terraforged.mod.profiler.ProfilerPrinter;
import com.terraforged.mod.profiler.Section;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.gen.GenerationStage;

public enum Profiler {
    STRUCTURE_STARTS("structure starts"),
    STRUCTURE_REFS("structure references"),
    BIOMES("biomes"),
    TERRAIN("base terrain"),
    SURFACE("biome surfaces"),
    AIR_CARVERS("air carvers"),
    FLUID_CARVERS("fluid carvers"),
    DECORATION("features & structures"),
    MOB_SPAWNS("mob spawns"),
    STRUCTURE_SEARCHES("structure searches");

    private static final Profiler[] VALUES;
    private final AtomicLong time = new AtomicLong();
    private final AtomicLong hits = new AtomicLong();
    private final AtomicLong longest = new AtomicLong();
    private final AtomicLong shortest = new AtomicLong(Long.MAX_VALUE);
    private final ThreadLocal<Section> section = ThreadLocal.withInitial(() -> new ProfilerSection());
    private final String reportDescription;

    private Profiler(String reportDescription) {
        this.reportDescription = reportDescription;
    }

    public String getReportDescription() {
        return this.reportDescription;
    }

    public Section punchIn() {
        return this.section.get().punchIn();
    }

    public void punchOut() {
        this.section.get().close();
    }

    public long timeMS() {
        return TimeUnit.NANOSECONDS.toMillis(this.time.get());
    }

    public long minMS() {
        long min = this.shortest.get();
        if (min == Long.MAX_VALUE) {
            return 0L;
        }
        return TimeUnit.NANOSECONDS.toMillis(min);
    }

    public long maxMS() {
        return TimeUnit.NANOSECONDS.toMillis(this.longest.get());
    }

    public long hits() {
        return this.hits.get();
    }

    public double averageMS() {
        return (double)this.timeMS() / Math.max(1.0, (double)this.hits());
    }

    public ITextComponent toText() {
        return new StringTextComponent(this.name().toLowerCase()).func_230529_a_((ITextComponent)new StringTextComponent(String.format(": %.3fms", this.averageMS())).func_240700_a_(style -> style.func_240712_a_(TextFormatting.WHITE))).func_240700_a_(style -> style.func_240712_a_(TextFormatting.YELLOW).func_240716_a_(Profiler.createHoverStats(this.minMS(), this.maxMS())));
    }

    public static Profiler get(GenerationStage.Carving stage) {
        return stage == GenerationStage.Carving.AIR ? AIR_CARVERS : FLUID_CARVERS;
    }

    public static HoverEvent createHoverStats(long min, long max) {
        String message = String.format("Min: %sms, Max: %sms", min, max);
        return new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent(message).func_240700_a_(s -> s.func_240712_a_(TextFormatting.WHITE)));
    }

    public static void reset() {
        for (Profiler profiler : VALUES) {
            profiler.time.set(0L);
            profiler.hits.set(0L);
            profiler.longest.set(0L);
            profiler.shortest.set(Long.MAX_VALUE);
        }
    }

    public static void dump(File dir) {
        Profiler.dump(dir.toPath());
    }

    public static void dump(Path dir) {
        try {
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            try (BufferedWriter writer = Files.newBufferedWriter(dir.resolve("dump-" + System.currentTimeMillis() + ".txt"), new OpenOption[0]);){
                ProfilerPrinter.print(writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        VALUES = Profiler.values();
    }

    private class ProfilerSection
    implements Section {
        private long timestamp = 0L;

        private ProfilerSection() {
        }

        @Override
        public Section punchIn() {
            this.timestamp = System.nanoTime();
            return this;
        }

        @Override
        public void close() {
            long min;
            long duration = System.nanoTime() - this.timestamp;
            Profiler.this.time.addAndGet(duration);
            Profiler.this.hits.incrementAndGet();
            if (duration <= 0L) {
                return;
            }
            long max = Profiler.this.longest.get();
            if (duration > max) {
                Profiler.this.longest.compareAndSet(max, duration);
            }
            if (duration < (min = Profiler.this.shortest.get())) {
                Profiler.this.shortest.compareAndSet(min, duration);
            }
        }
    }
}

