/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.template.feature;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.terraforged.mod.featuremanager.template.decorator.DecoratorConfig;
import com.terraforged.mod.featuremanager.template.paste.PasteConfig;
import com.terraforged.mod.featuremanager.template.template.Template;
import com.terraforged.mod.featuremanager.template.template.TemplateLoader;
import com.terraforged.mod.featuremanager.template.template.TemplateManager;
import com.terraforged.mod.featuremanager.template.type.FeatureType;
import com.terraforged.mod.featuremanager.template.type.FeatureTypes;
import com.terraforged.mod.featuremanager.util.Json;
import com.terraforged.mod.featuremanager.util.codec.CodecException;
import com.terraforged.mod.featuremanager.util.codec.Codecs;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class TemplateFeatureConfig
implements IFeatureConfig {
    public static final TemplateFeatureConfig NONE = new TemplateFeatureConfig();
    public static final Codec<TemplateFeatureConfig> CODEC = Codecs.create(TemplateFeatureConfig::serialize, TemplateFeatureConfig::deserialize);
    public final ResourceLocation name;
    public final FeatureType type;
    public final PasteConfig paste;
    public final List<Template> templates;
    public final DecoratorConfig<?> decorator;

    private TemplateFeatureConfig() {
        this.name = new ResourceLocation("fm", "none");
        this.type = FeatureTypes.ANY;
        this.paste = PasteConfig.DEFAULT;
        this.templates = Collections.emptyList();
        this.decorator = null;
    }

    public TemplateFeatureConfig(ResourceLocation name, FeatureType type, PasteConfig paste, List<Template> templates, DecoratorConfig<?> decorator) {
        this.name = name;
        this.type = type;
        this.paste = paste;
        this.templates = templates;
        this.decorator = decorator;
        type.register(name);
    }

    public static <T> Dynamic<T> serialize(TemplateFeatureConfig config, DynamicOps<T> ops) {
        return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("template"), (Object)ops.createString(config.name.toString()))));
    }

    public static <T> TemplateFeatureConfig deserialize(Dynamic<T> dynamic) {
        ResourceLocation name = Codecs.getResult(dynamic.get("template").asString()).map(ResourceLocation::func_208304_a).orElseThrow(CodecException.get("Failed to load template entry", new Object[0]));
        TemplateFeatureConfig config = TemplateManager.getInstance().getTemplateConfig(name);
        if (config == NONE) {
            throw CodecException.of("Failed to load config entry for %s", name);
        }
        return config;
    }

    public static TemplateFeatureConfig parse(TemplateLoader loader, JsonObject root) throws IOException {
        try {
            ResourceLocation name = new ResourceLocation(Json.getString("name", root));
            FeatureType type = FeatureTypes.getType(Json.getString("type", root));
            PasteConfig paste = PasteConfig.parse(root.getAsJsonObject("config"));
            DecoratorConfig<?> decorator = DecoratorConfig.parse(type.getDecorator(), root.getAsJsonObject("decorators"));
            List<Template> templates = loader.load(name.func_110624_b(), root.getAsJsonArray("paths"));
            return new TemplateFeatureConfig(name, type, paste, templates, decorator);
        }
        catch (CodecException e) {
            throw new IOException(e);
        }
    }
}

