/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.matcher;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.terraforged.engine.world.biome.map.BiomeContext;
import com.terraforged.mod.featuremanager.matcher.biome.BiomeMatcher;
import com.terraforged.mod.featuremanager.matcher.feature.FeatureMatcher;
import com.terraforged.mod.featuremanager.modifier.Jsonifiable;
import java.util.function.BiPredicate;
import net.minecraft.world.biome.Biome;

public class BiomeFeatureMatcher
implements BiPredicate<Biome, JsonElement>,
Comparable<BiomeFeatureMatcher>,
Jsonifiable {
    public static final BiomeFeatureMatcher ANY = new BiomeFeatureMatcher("ANY", BiomeMatcher.ANY, FeatureMatcher.ANY);
    private final String name;
    private final BiomeMatcher biomeMatcher;
    private final FeatureMatcher featureMatcher;

    public BiomeFeatureMatcher(BiomeMatcher biomeMatcher, FeatureMatcher featureMatcher) {
        this("unknown", biomeMatcher, featureMatcher);
    }

    public BiomeFeatureMatcher(String name, BiomeMatcher biomeMatcher, FeatureMatcher featureMatcher) {
        this.name = name;
        this.biomeMatcher = biomeMatcher;
        this.featureMatcher = featureMatcher;
    }

    @Override
    public boolean test(Biome biome, JsonElement feature) {
        return this.getBiomeMatcher().test(biome) && this.getFeatureMatcher().test(feature);
    }

    public String getName() {
        return this.name;
    }

    public BiomeMatcher getBiomeMatcher() {
        return this.biomeMatcher;
    }

    public FeatureMatcher getFeatureMatcher() {
        return this.featureMatcher;
    }

    @Override
    public int compareTo(BiomeFeatureMatcher o) {
        return this.biomeMatcher.compareTo(o.biomeMatcher);
    }

    @Override
    public String getType() {
        return "";
    }

    @Override
    public JsonElement toJson(BiomeContext<?> context) {
        return JsonNull.INSTANCE;
    }

    @Override
    public void append(JsonObject parent, BiomeContext<?> context) {
        this.biomeMatcher.append(parent, context);
        this.featureMatcher.append(parent, context);
    }
}

