/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.decorator.poisson;

import com.terraforged.engine.concurrent.cache.SafeCloseable;
import com.terraforged.mod.feature.decorator.poisson.BiomeVariance;
import com.terraforged.noise.Module;
import com.terraforged.noise.util.NoiseUtil;

public class DensityNoise
implements SafeCloseable,
Module {
    private final BiomeVariance biome;
    private final Module variance;

    public DensityNoise(BiomeVariance biome, Module variance) {
        this.biome = biome;
        this.variance = variance;
    }

    @Override
    public float getValue(int seed, float x, float y) {
        float value1 = this.biome.getValue(seed, x, y);
        if (value1 > 2.0f) {
            return value1;
        }
        float value2 = this.variance.getValue(seed, x, y);
        if (value1 > 1.0f) {
            return NoiseUtil.lerp(value2, value1, (value1 - 0.25f) / 0.25f);
        }
        return value2;
    }

    @Override
    public void close() {
        this.biome.close();
    }
}

