/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature;

import com.terraforged.engine.cell.Cell;
import com.terraforged.engine.tile.chunk.ChunkReader;
import com.terraforged.engine.world.heightmap.Levels;
import com.terraforged.mod.chunk.TFChunkGenerator;
import com.terraforged.mod.featuremanager.predicate.FeaturePredicate;
import com.terraforged.noise.Module;
import com.terraforged.noise.Source;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;

public class VolcanoPredicate
implements FeaturePredicate {
    private final Module threshold;
    private final TFChunkGenerator generator;

    public VolcanoPredicate(TFChunkGenerator generator) {
        Levels levels = generator.getContext().levels;
        this.generator = generator;
        this.threshold = Source.perlin(235, 75, 1).scale(levels.scale(32)).bias(levels.ground(24));
    }

    @Override
    public boolean test(IChunk chunk, Biome biome) {
        try (ChunkReader reader = this.generator.getChunkReader(chunk.func_76632_l());){
            Cell cell = reader.getCell(8, 8);
            if (cell.terrain.isVolcano()) {
                boolean bl = this.testHeight(reader, cell);
                return bl;
            }
        }
        return true;
    }

    public String toString() {
        return "VOLCANO";
    }

    private boolean testHeight(ChunkReader chunk, Cell cell) {
        int z;
        int x = chunk.getBlockX() + 8;
        return cell.value < this.threshold.getValue(0, x, z = chunk.getBlockZ() + 8);
    }
}

