/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.data;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.terraforged.engine.world.biome.map.BiomeMap;
import com.terraforged.mod.biome.context.TFBiomeContext;
import com.terraforged.mod.biome.provider.BiomeWeights;
import com.terraforged.mod.biome.provider.analyser.BiomeAnalyser;
import com.terraforged.mod.data.DataGen;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.stream.IntStream;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;

public class WorldGenBiomes
extends DataGen {
    private static final String FORGE_REG_NAME_KEY = "forge:registry_name";

    public static void genBiomeMap(File dataDir, TFBiomeContext context) {
        if (dataDir.exists() || dataDir.mkdirs()) {
            BiomeMap<RegistryKey<Biome>> map = BiomeAnalyser.createBiomeMap(context);
            JsonObject rootJson = new JsonObject();
            map.forEach((terrain, biomeSet) -> {
                JsonObject biomeGroups = new JsonObject();
                rootJson.add(terrain, (JsonElement)biomeGroups);
                biomeSet.forEach((type, biomes) -> {
                    JsonArray biomesArray = new JsonArray();
                    biomeGroups.add(type, (JsonElement)biomesArray);
                    IntStream.of(biomes).distinct().mapToObj(map.getContext()::getName).sorted().forEach(arg_0 -> ((JsonArray)biomesArray).add(arg_0));
                });
            });
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(dataDir, "biome_map.json")));){
                new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)rootJson, (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void genBiomeWeights(File dataDir, TFBiomeContext context) {
        if (dataDir.exists() || dataDir.mkdirs()) {
            BiomeWeights weights = new BiomeWeights(context);
            try (PrintWriter writer = WorldGenBiomes.newPrinter(dataDir, "biome_weights.conf");){
                writer.println("# REGISTERED BIOME WEIGHTS");
                weights.forEachEntry((name, weight) -> WorldGenBiomes.write(name, weight, writer));
                writer.println("# UNREGISTERED BIOME WEIGHTS");
                weights.forEachUnregistered((name, weight) -> WorldGenBiomes.write(name, weight, writer));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static PrintWriter newPrinter(File dir, String filename) throws IOException {
        return new PrintWriter(new BufferedWriter(new FileWriter(new File(dir, filename))));
    }

    private static void write(String name, int weight, PrintWriter writer) {
        writer.print('\"');
        writer.print(name);
        writer.print('\"');
        writer.print(" = ");
        writer.println(weight);
    }
}

