/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client.gui.screen.preview;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.terraforged.mod.chunk.settings.TerraSettings;
import com.terraforged.mod.client.gui.GuiKeys;
import com.terraforged.mod.client.gui.element.TFButton;
import com.terraforged.mod.client.gui.page.Page;
import com.terraforged.mod.client.gui.screen.overlay.OverlayScreen;
import com.terraforged.mod.client.gui.screen.page.UpdatablePage;
import com.terraforged.mod.client.gui.screen.preview.Preview;
import com.terraforged.mod.client.gui.screen.preview.PreviewSettings;
import com.terraforged.mod.util.DataUtils;
import java.util.function.Consumer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.nbt.CompoundNBT;

public class PreviewPage
extends UpdatablePage {
    private final boolean demo;
    private final Preview preview;
    private final TerraSettings settings;
    private final CompoundNBT previewerSettings = DataUtils.toNBT("preview", new PreviewSettings());

    public PreviewPage(TerraSettings settings, int seed) {
        this.preview = new Preview(seed);
        this.settings = settings;
        this.demo = false;
    }

    public PreviewPage(TerraSettings settings, int seed, boolean demo) {
        super(0.0f, 1.0f, 0.0f);
        this.preview = new Preview(seed);
        this.settings = settings;
        this.demo = demo;
    }

    public Preview getPreviewWidget() {
        return this.preview;
    }

    public int getSeed() {
        return this.preview.getSeed();
    }

    @Override
    public void apply(Consumer<TerraSettings> consumer) {
        consumer.accept(this.settings);
        this.preview.update(this.settings, this.previewerSettings);
    }

    @Override
    public void close() {
        this.preview.close();
    }

    @Override
    public void init(OverlayScreen parent) {
        Page.Column right = this.getColumn(1);
        this.preview.field_230690_l_ = 0;
        this.preview.field_230691_m_ = 0;
        this.preview.func_230991_b_(Preview.SIZE);
        this.preview.setHeight(Preview.SIZE);
        if (!this.demo) {
            this.addElements(right.left, right.top, right, this.previewerSettings, right.scrollPane::addButton, this::update);
        }
        right.scrollPane.addButton((Widget)new TFButton(GuiKeys.PREVIEW_SEED.get()){

            public void func_230930_b_() {
                PreviewPage.this.preview.regenerate();
                PreviewPage.this.update();
            }
        });
        right.scrollPane.addButton((Widget)this.preview);
        TFButton spacer = PreviewPage.createSpacer();
        for (int i = 0; i < 10; ++i) {
            right.scrollPane.addButton((Widget)spacer);
        }
        this.update();
    }

    @Override
    public void update() {
        this.preview.update(this.settings, this.previewerSettings);
    }

    private static TFButton createSpacer() {
        return new TFButton(""){

            public void func_230430_a_(MatrixStack matrixStack, int x, int y, float tick) {
            }
        };
    }
}

