/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client.gui.screen.preview;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.terraforged.engine.cell.Cell;
import com.terraforged.engine.concurrent.cache.CacheManager;
import com.terraforged.engine.concurrent.task.LazyCallable;
import com.terraforged.engine.concurrent.thread.ThreadPool;
import com.terraforged.engine.concurrent.thread.ThreadPools;
import com.terraforged.engine.settings.Settings;
import com.terraforged.engine.tile.Size;
import com.terraforged.engine.tile.Tile;
import com.terraforged.engine.tile.api.TileFactory;
import com.terraforged.engine.tile.gen.TileGenerator;
import com.terraforged.engine.util.pos.PosUtil;
import com.terraforged.engine.world.GeneratorContext;
import com.terraforged.engine.world.WorldGeneratorFactory;
import com.terraforged.engine.world.continent.MutableVeci;
import com.terraforged.engine.world.continent.SpawnType;
import com.terraforged.engine.world.heightmap.Levels;
import com.terraforged.mod.client.gui.GuiKeys;
import com.terraforged.mod.client.gui.screen.preview.PreviewSettings;
import com.terraforged.mod.client.gui.screen.preview.RenderMode;
import com.terraforged.mod.util.DataUtils;
import com.terraforged.noise.util.NoiseUtil;
import java.awt.Color;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class Preview
extends Button {
    private static final int FACTOR = 4;
    public static final int SIZE = Size.chunkToBlock(16);
    private static final float[] LEGEND_SCALES = new float[]{1.0f, 0.9f, 0.75f, 0.6f};
    private final int offsetX;
    private final int offsetZ;
    private final ThreadPool threadPool = ThreadPools.createDefault();
    private final Random random = new Random(System.currentTimeMillis());
    private final PreviewSettings previewSettings = new PreviewSettings();
    private final DynamicTexture texture = new DynamicTexture(new NativeImage(SIZE, SIZE, true));
    private int seed;
    private long lastUpdate = 0L;
    private Tile tile = null;
    private LazyCallable<Tile> task = null;
    private CompoundNBT lastWorldSettings = null;
    private CompoundNBT lastPreviewSettings = null;
    private Settings settings = new Settings();
    private MutableVeci center = new MutableVeci();
    private String hoveredCoords = "";
    private String[] values = new String[]{"", "", ""};
    private String[] labels = new String[]{GuiKeys.PREVIEW_AREA.get(), GuiKeys.PREVIEW_TERRAIN.get(), GuiKeys.PREVIEW_BIOME.get()};

    public Preview(int seed) {
        super(0, 0, 0, 0, (ITextComponent)new StringTextComponent(""), b -> {});
        this.seed = seed == -1 ? this.random.nextInt() : seed;
        this.offsetX = 0;
        this.offsetZ = 0;
    }

    public int getSeed() {
        return this.seed;
    }

    public void regenerate() {
        this.seed = this.random.nextInt();
        this.lastWorldSettings = null;
        this.lastPreviewSettings = null;
    }

    public void close() {
        this.texture.close();
        this.threadPool.shutdown();
        CacheManager.get().clear();
    }

    public boolean click(double mx, double my) {
        if (this.updateLegend((int)mx, (int)my) && !this.hoveredCoords.isEmpty()) {
            super.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.hoveredCoords);
            return true;
        }
        return false;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mx, int my, float partialTicks) {
        this.field_230689_k_ = this.getSize();
        this.preRender();
        this.texture.func_229148_d_();
        RenderSystem.enableBlend();
        RenderSystem.enableRescaleNormal();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)0.0f, (float)0.0f, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)this.field_230688_j_, (int)this.field_230689_k_);
        RenderSystem.disableRescaleNormal();
        this.updateLegend(mx, my);
        this.renderLegend(matrixStack, mx, my, this.labels, this.values, this.field_230690_l_, this.field_230691_m_ + this.field_230688_j_, 10, 0xFFFFFF);
    }

    public void update(Settings settings, CompoundNBT prevSettings) {
        long time = System.currentTimeMillis();
        if (time - this.lastUpdate < 20L) {
            return;
        }
        CompoundNBT previewSettings = prevSettings.func_74737_b();
        CompoundNBT worldSettings = DataUtils.toCompactNBT(settings);
        if (Objects.equals(this.lastWorldSettings, worldSettings) && Objects.equals(this.lastPreviewSettings, previewSettings)) {
            return;
        }
        this.lastUpdate = time;
        this.lastWorldSettings = worldSettings;
        this.lastPreviewSettings = previewSettings;
        DataUtils.fromNBT(prevSettings, previewSettings);
        settings.world.seed = this.seed;
        this.task = this.generate(settings, prevSettings);
    }

    private int getSize() {
        return this.field_230688_j_;
    }

    private void preRender() {
        if (this.task != null && this.task.isDone()) {
            try {
                this.tile = this.task.get();
                this.render(this.tile);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                this.task = null;
            }
        }
    }

    private void render(Tile tile) {
        NativeImage image = this.texture.func_195414_e();
        if (image == null) {
            return;
        }
        RenderMode renderer = this.previewSettings.display;
        Levels levels = new Levels(this.settings.world);
        int stroke = 2;
        int width = tile.getBlockSize().size;
        tile.iterate((cell, x, z) -> {
            if (x < stroke || z < stroke || x >= width - stroke || z >= width - stroke) {
                image.func_195700_a(x, z, Color.BLACK.getRGB());
            } else {
                image.func_195700_a(x, z, renderer.getColor(cell, levels));
            }
        });
        this.texture.func_110564_a();
    }

    private LazyCallable<Tile> generate(Settings settings, CompoundNBT prevSettings) {
        DataUtils.fromNBT(prevSettings, this.previewSettings);
        settings.world.seed = this.seed;
        this.settings = settings;
        CacheManager.get().clear();
        GeneratorContext context = GeneratorContext.createNoCache(settings);
        if (settings.world.properties.spawnType == SpawnType.CONTINENT_CENTER) {
            long center = ((WorldGeneratorFactory)context.worldGenerator.get()).getHeightmap().getContinent().getNearestCenter(this.offsetX, this.offsetZ);
            this.center.x = PosUtil.unpackLeft(center);
            this.center.z = PosUtil.unpackRight(center);
        } else {
            this.center.x = 0;
            this.center.z = 0;
        }
        TileFactory renderer = TileGenerator.builder().factory((WorldGeneratorFactory)context.worldGenerator.get()).size(4, 0).pool(this.threadPool).batch(6).build().async();
        return renderer.getTile(this.center.x, this.center.z, this.getZoom(), false);
    }

    private boolean updateLegend(int mx, int my) {
        if (this.tile != null) {
            int left = this.field_230690_l_;
            int top = this.field_230691_m_;
            float size = this.field_230688_j_;
            int zoom = this.getZoom();
            int width = Math.max(1, this.tile.getBlockSize().size * zoom);
            int height = Math.max(1, this.tile.getBlockSize().size * zoom);
            this.values[0] = width + "x" + height;
            if (mx >= left && (float)mx <= (float)left + size && my >= top && (float)my <= (float)top + size) {
                float fx = (float)(mx - left) / size;
                float fz = (float)(my - top) / size;
                int ix = NoiseUtil.round(fx * (float)this.tile.getBlockSize().size);
                int iz = NoiseUtil.round(fz * (float)this.tile.getBlockSize().size);
                Cell cell = this.tile.getCell(ix, iz);
                this.values[1] = Preview.getTerrainName(cell);
                this.values[2] = Preview.getBiomeName(cell);
                int dx = (ix - this.tile.getBlockSize().size / 2) * zoom;
                int dz = (iz - this.tile.getBlockSize().size / 2) * zoom;
                this.hoveredCoords = this.center.x + dx + ":" + (this.center.z + dz);
                return true;
            }
            this.hoveredCoords = "";
        }
        return false;
    }

    private float getLegendScale() {
        int index = Minecraft.func_71410_x().field_71474_y.field_74335_Z - 1;
        if (index < 0 || index >= LEGEND_SCALES.length) {
            index = LEGEND_SCALES.length - 1;
        }
        return LEGEND_SCALES[index];
    }

    private void renderLegend(MatrixStack matrixStack, int mx, int my, String[] labels, String[] values, int left, int top, int lineHeight, int color) {
        float scale = this.getLegendScale();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)((float)left + 3.75f * scale), (float)((float)top - (float)lineHeight * (3.2f * scale)), (float)0.0f);
        RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
        FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
        int spacing = 0;
        for (String s : labels) {
            spacing = Math.max(spacing, renderer.func_78256_a(s));
        }
        float maxWidth = (float)(this.field_230688_j_ - 4) / scale;
        for (int i = 0; i < labels.length && i < values.length; ++i) {
            String label = labels[i];
            String value = values[i];
            while (value.length() > 0 && (float)(spacing + renderer.func_78256_a(value)) > maxWidth) {
                value = value.substring(0, value.length() - 1);
            }
            Preview.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)renderer, (String)label, (int)0, (int)(i * lineHeight), (int)color);
            Preview.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)renderer, (String)value, (int)spacing, (int)(i * lineHeight), (int)color);
        }
        RenderSystem.popMatrix();
        if (PreviewSettings.showCoords && !this.hoveredCoords.isEmpty()) {
            Preview.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)renderer, (String)this.hoveredCoords, (int)mx, (int)(my - 10), (int)0xFFFFFF);
        }
    }

    private int getZoom() {
        return NoiseUtil.round(1.5f * (float)(101 - this.previewSettings.zoom));
    }

    private static String getTerrainName(Cell cell) {
        if (cell.terrain.isRiver()) {
            return "river";
        }
        return cell.terrain.getName().toLowerCase();
    }

    private static String getBiomeName(Cell cell) {
        String terrain = cell.terrain.getName().toLowerCase();
        if (terrain.contains("ocean")) {
            if ((double)cell.temperature < 0.3) {
                return "cold_" + terrain;
            }
            if ((double)cell.temperature > 0.6) {
                return "warm_" + terrain;
            }
            return terrain;
        }
        if (terrain.contains("river")) {
            return "river";
        }
        return cell.biome.name().toLowerCase();
    }
}

