/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client.gui.screen;

import com.google.gson.JsonElement;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.terraforged.mod.LevelType;
import com.terraforged.mod.Log;
import com.terraforged.mod.chunk.TFChunkGenerator;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.chunk.settings.TerraSettings;
import com.terraforged.mod.client.gui.GuiKeys;
import com.terraforged.mod.client.gui.element.TFLabel;
import com.terraforged.mod.client.gui.page.Page;
import com.terraforged.mod.client.gui.page.SimplePage;
import com.terraforged.mod.client.gui.screen.Instance;
import com.terraforged.mod.client.gui.screen.overlay.OverlayScreen;
import com.terraforged.mod.client.gui.screen.page.PresetsPage;
import com.terraforged.mod.client.gui.screen.page.SimplePreviewPage;
import com.terraforged.mod.client.gui.screen.page.WorldPage;
import com.terraforged.mod.client.gui.screen.preview.PreviewPage;
import com.terraforged.mod.util.DataUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;

public class ConfigScreen
extends OverlayScreen {
    private static final Button.IPressable NO_ACTION = b -> {};
    private final Page[] pages;
    private final PreviewPage preview;
    private final CreateWorldScreen parent;
    private final DimensionGeneratorSettings inputSettings;
    private final Instance instance;
    private int pageIndex = 0;
    private DimensionGeneratorSettings outputSettings;

    public ConfigScreen(CreateWorldScreen parent, DimensionGeneratorSettings settings) {
        this.inputSettings = settings;
        this.outputSettings = settings;
        this.parent = parent;
        this.instance = new Instance(ConfigScreen.getInitialSettings(settings));
        this.preview = new PreviewPage(this.instance.settings, ConfigScreen.getSeed(parent));
        this.pages = new Page[]{new PresetsPage(this, this.instance, this.preview, (Widget)this.preview.getPreviewWidget()), new WorldPage(this.instance, this.preview), new SimplePreviewPage(GuiKeys.CLIMATE_SETTINGS, "climate", this.preview, this.instance, s -> s.climate), new SimplePreviewPage(GuiKeys.TERRAIN_SETTINGS, "terrain", this.preview, this.instance, s -> s.terrain), new SimplePreviewPage(GuiKeys.RIVER_SETTINGS, "rivers", this.preview, this.instance, s -> s.rivers), new SimplePreviewPage(GuiKeys.FILTER_SETTINGS, "filters", this.preview, this.instance, s -> s.filters), new SimplePage(GuiKeys.STRUCTURE_SETTINGS, "structures", this.instance, s -> s.structures), new SimplePage(GuiKeys.MISC_SETTINGS, "miscellaneous", this.instance, s -> s.miscellaneous)};
    }

    private boolean isPresetsPage() {
        return this.pages[this.pageIndex] instanceof PresetsPage;
    }

    @Override
    public void func_231160_c_() {
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        int buttonsCenter = this.field_230708_k_ / 2;
        int buttonWidth = 50;
        int buttonHeight = 20;
        int buttonPad = 2;
        int buttonsRow = this.field_230709_l_ - 25;
        if (this.pageIndex < this.pages.length) {
            Page page = this.pages[this.pageIndex];
            TFLabel title = new TFLabel(page.getTitle());
            title.field_230694_p_ = true;
            title.field_230690_l_ = 16;
            title.field_230691_m_ = 15;
            this.field_230710_m_.add(title);
            try {
                page.initPage(10, 30, this);
                this.preview.initPage(10, 30, this);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.func_230480_a_(new Button(buttonsCenter - buttonWidth - buttonPad, buttonsRow, buttonWidth, buttonHeight, GuiKeys.CANCEL.getText(), b -> this.func_231175_as__()));
        this.func_230480_a_(new Button(buttonsCenter + buttonPad, buttonsRow, buttonWidth, buttonHeight, GuiKeys.DONE.getText(), b -> {
            for (Page page : this.pages) {
                page.save();
            }
            Log.debug("Updating generator settings...", new Object[0]);
            TerraSettings settings = this.instance.copySettings();
            DynamicRegistries.Impl registries = this.parent.field_238934_c_.func_239055_b_();
            this.outputSettings = LevelType.updateOverworld(this.inputSettings, (DynamicRegistries)registries, settings);
            Log.debug("Updating seed...", new Object[0]);
            ConfigScreen.setSeed(this.parent, this.preview.getSeed());
            this.func_231175_as__();
        }));
        this.func_230480_a_(new Button(buttonsCenter - (buttonWidth * 2 + buttonPad * 3), buttonsRow, buttonWidth, buttonHeight, (ITextComponent)new StringTextComponent("<<"), NO_ACTION){

            public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                this.field_230693_o_ = ConfigScreen.this.hasPrevious();
                super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            }

            public void func_230982_a_(double mouseX, double mouseY) {
                super.func_230982_a_(mouseX, mouseY);
                if (ConfigScreen.this.hasPrevious()) {
                    ConfigScreen.this.pageIndex--;
                    ConfigScreen.this.func_231160_c_();
                }
            }
        });
        this.func_230480_a_(new Button(buttonsCenter + buttonWidth + buttonPad * 3, buttonsRow, buttonWidth, buttonHeight, (ITextComponent)new StringTextComponent(">>"), NO_ACTION){

            public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                this.field_230693_o_ = ConfigScreen.this.hasNext();
                super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            }

            public void func_230982_a_(double mouseX, double mouseY) {
                super.func_230982_a_(mouseX, mouseY);
                if (ConfigScreen.this.hasNext()) {
                    ConfigScreen.this.pageIndex++;
                    ConfigScreen.this.func_231160_c_();
                }
            }
        });
        super.func_231160_c_();
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230446_a_(matrixStack);
        this.pages[this.pageIndex].visit(pane -> pane.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks));
        if (this.pageIndex > 0) {
            this.preview.visit(pane -> pane.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks));
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderOverlays(MatrixStack matrixStack, Screen screen, int mouseX, int mouseY) {
        super.renderOverlays(matrixStack, screen, mouseX, mouseY);
        this.pages[this.pageIndex].visit(pane -> pane.renderOverlays(matrixStack, screen, mouseX, mouseY));
        if (!this.isPresetsPage()) {
            this.preview.visit(pane -> pane.renderOverlays(matrixStack, screen, mouseX, mouseY));
        }
    }

    public boolean func_231044_a_(double x, double y, int button) {
        boolean a = this.pages[this.pageIndex].action(pane -> pane.func_231044_a_(x, y, button));
        boolean b = this.isPresetsPage() || this.preview.action(pane -> pane.func_231044_a_(x, y, button));
        boolean c = this.preview.getPreviewWidget().click(x, y);
        boolean d = super.func_231044_a_(x, y, button);
        return a || b || c || d;
    }

    public boolean func_231048_c_(double x, double y, int button) {
        boolean a = this.pages[this.pageIndex].action(pane -> pane.func_231048_c_(x, y, button));
        boolean b = this.isPresetsPage() || this.preview.action(pane -> pane.func_231048_c_(x, y, button));
        boolean c = super.func_231048_c_(x, y, button);
        return a || b || c;
    }

    public boolean func_231045_a_(double x, double y, int button, double dx, double dy) {
        boolean a = this.pages[this.pageIndex].action(pane -> pane.func_231045_a_(x, y, button, dx, dy));
        boolean b = this.isPresetsPage() || this.preview.action(pane -> pane.func_231045_a_(x, y, button, dx, dy));
        boolean c = super.func_231045_a_(x, y, button, dx, dy);
        return a || b || c;
    }

    public boolean func_231043_a_(double x, double y, double direction) {
        boolean a = this.pages[this.pageIndex].action(pane -> pane.func_231043_a_(x, y, direction));
        boolean b = this.isPresetsPage() || this.preview.action(pane -> pane.func_231043_a_(x, y, direction));
        boolean c = super.func_231043_a_(x, y, direction);
        return a || b || c;
    }

    public boolean func_231046_a_(int i, int j, int k) {
        boolean a = this.pages[this.pageIndex].action(pane -> pane.func_231046_a_(i, j, k));
        boolean b = this.isPresetsPage() || this.preview.action(pane -> pane.func_231046_a_(i, j, k));
        boolean c = super.func_231046_a_(i, j, k);
        return a || b || c;
    }

    public boolean func_231042_a_(char ch, int code) {
        boolean a = this.pages[this.pageIndex].action(pane -> pane.func_231042_a_(ch, code));
        boolean b = this.isPresetsPage() || this.preview.action(pane -> pane.func_231042_a_(ch, code));
        boolean c = super.func_231042_a_(ch, code);
        return a || b || c;
    }

    public void func_231175_as__() {
        Log.debug("Returning to parent screen", new Object[0]);
        for (Page page : this.pages) {
            page.close();
        }
        this.preview.close();
        Minecraft.func_71410_x().func_147108_a((Screen)this.parent);
        this.parent.field_238934_c_.func_239043_a_(this.outputSettings);
    }

    public void loadPresetStructures(TerraSettings presetSettings) {
        DimensionGeneratorSettings level = this.inputSettings;
        if (level.func_236225_f_() instanceof TFChunkGenerator) {
            TerraContext context = ((TFChunkGenerator)level.func_236225_f_()).getContext();
            DimensionStructuresSettings structuresSettings = level.func_236225_f_().func_235957_b_();
            presetSettings.structures.addSettings(structuresSettings);
            presetSettings.structures.hideNonOverworld(context.biomeContext);
        }
    }

    private boolean hasNext() {
        return this.pageIndex + 1 < this.pages.length;
    }

    private boolean hasPrevious() {
        return this.pageIndex > 0;
    }

    protected static int getSeed(CreateWorldScreen screen) {
        TextFieldWidget field = ConfigScreen.getWidget(screen);
        if (field != null && !field.func_146179_b().isEmpty()) {
            try {
                long seed = Long.parseLong(field.func_146179_b());
                return (int)seed;
            }
            catch (NumberFormatException var6) {
                return field.func_146179_b().hashCode();
            }
        }
        return -1;
    }

    protected static TerraSettings getInitialSettings(DimensionGeneratorSettings level) {
        if (level.func_236225_f_() instanceof TFChunkGenerator) {
            TerraContext context = ((TFChunkGenerator)level.func_236225_f_()).getContext();
            DimensionStructuresSettings structuresSettings = level.func_236225_f_().func_235957_b_();
            TerraSettings settings = context.terraSettings;
            TerraSettings copy = new TerraSettings(settings.world.seed);
            JsonElement dataCopy = DataUtils.toJson(settings);
            DataUtils.fromJson(dataCopy, copy);
            copy.structures.addSettings(structuresSettings);
            copy.structures.hideNonOverworld(context.biomeContext);
            return copy;
        }
        throw new IllegalStateException("Not a TerraForged generator :[");
    }

    protected static void setSeed(CreateWorldScreen screen, int seed) {
        TextFieldWidget field = ConfigScreen.getWidget(screen);
        if (field != null) {
            field.func_146180_a(String.valueOf(seed));
        }
    }

    private static TextFieldWidget getWidget(CreateWorldScreen screen) {
        String message = I18n.func_135052_a((String)"selectWorld.enterSeed", (Object[])new Object[0]);
        for (IGuiEventListener widget : screen.func_231039_at__()) {
            TextFieldWidget field;
            if (!(widget instanceof TextFieldWidget) || !(field = (TextFieldWidget)widget).func_230458_i_().getString().equals(message)) continue;
            return field;
        }
        return null;
    }

    public static ConfigScreen create(CreateWorldScreen parent, DimensionGeneratorSettings settings) {
        return new ConfigScreen(parent, settings);
    }
}

