/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.settings;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.terraforged.engine.serialization.annotation.Serializable;
import com.terraforged.engine.settings.Settings;
import com.terraforged.mod.Log;
import com.terraforged.mod.chunk.settings.DimensionSettings;
import com.terraforged.mod.chunk.settings.Miscellaneous;
import com.terraforged.mod.chunk.settings.StructureSettings;
import com.terraforged.mod.featuremanager.util.codec.Codecs;
import com.terraforged.mod.util.DataUtils;
import com.terraforged.mod.util.nbt.DynamicReader;
import com.terraforged.mod.util.nbt.DynamicWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

@Serializable
public class TerraSettings
extends Settings {
    public static final Codec<TerraSettings> CODEC = Codecs.create(TerraSettings::encode, TerraSettings::decode);
    public Miscellaneous miscellaneous = new Miscellaneous();
    public DimensionSettings dimensions = new DimensionSettings();
    public StructureSettings structures = new StructureSettings();

    public TerraSettings() {
    }

    public TerraSettings(long seed) {
        this.world.seed = seed;
    }

    private static <T> Dynamic<T> encode(TerraSettings settings, DynamicOps<T> ops) {
        return new Dynamic(ops, DynamicWriter.serialize(settings, ops, false));
    }

    private static <T> TerraSettings decode(Dynamic<T> dynamic) {
        return DynamicReader.deserialize(new TerraSettings(), dynamic);
    }

    public static TerraSettings defaults(long seed) {
        TerraSettings settings = new TerraSettings();
        settings.world.seed = seed;
        return settings;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TerraSettings read(InputStream inputStream) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            TerraSettings settings = new TerraSettings();
            JsonElement data = new JsonParser().parse((Reader)reader);
            if (!DataUtils.fromJson(data, settings)) {
                Log.warn("Error parsing settings json {}", data);
            }
            TerraSettings terraSettings = settings;
            return terraSettings;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

