/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.settings;

import com.terraforged.engine.serialization.annotation.Comment;
import com.terraforged.engine.serialization.annotation.Range;
import com.terraforged.engine.serialization.annotation.Serializable;

@Serializable
public class Miscellaneous {
    @Comment(value={"Modifies layer block levels (ie snow) to fit the terrain"})
    public boolean smoothLayerDecorator = true;
    @Range(min=50.0f, max=1000.0f)
    @Comment(value={"Controls the size of strata regions"})
    public int strataRegionSize = 600;
    @Comment(value={"Generates strata (rock layers) instead of just stone"})
    public boolean strataDecorator = true;
    @Comment(value={"Only use stone types that ores can generate in"})
    public boolean oreCompatibleStoneOnly = true;
    @Comment(value={"Replace surface materials where erosion has occurred"})
    public boolean erosionDecorator = true;
    @Comment(value={"Changes most exposed rock surfaces to plain stone"})
    public boolean plainStoneErosion = false;
    @Comment(value={"Removes snow from the terrain where it shouldn't naturally settle"})
    public boolean naturalSnowDecorator = true;
    @Comment(value={"Use custom biome features in place of vanilla ones (such as trees)"})
    public boolean customBiomeFeatures = true;
    @Comment(value={"Allow vanilla lakes to generate"})
    public boolean vanillaLakes = false;
    @Comment(value={"Allow vanilla springs (water source blocks) to generate"})
    public boolean vanillaSprings = true;
    @Comment(value={"Allow vanilla lava-lakes to generate"})
    public boolean vanillaLavaLakes = true;
    @Comment(value={"Allow vanilla springs (lava source blocks) to generate"})
    public boolean vanillaLavaSprings = true;
    @Comment(value={"The probability that mountainous terrain will be set to a mountain biome type.", "This may help improve compatibility with mods that rely exclusively on mountain biomes."})
    @Range(min=0.0f, max=1.0f)
    public float mountainBiomeUsage = 0.4f;
    @Comment(value={"The probability that volcano terrain will be set to a volcano biome type.", "This may help improve compatibility with mods that rely exclusively on volcano biomes."})
    @Range(min=0.0f, max=1.0f)
    public float volcanoBiomeUsage = 0.4f;
}

