/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.surface;

import com.terraforged.engine.world.GeneratorContext;
import com.terraforged.mod.api.biome.surface.Surface;
import com.terraforged.mod.api.biome.surface.SurfaceContext;
import com.terraforged.mod.api.material.state.States;
import com.terraforged.noise.Module;
import com.terraforged.noise.Source;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.Heightmap;

public class ForestSurface
implements Surface {
    private final Module noise;

    public ForestSurface(GeneratorContext context) {
        this.noise = Source.simplex(context.seed.next(), 50, 2).warp(Source.RAND, context.seed.next(), 2, 1, 3.0);
    }

    @Override
    public void buildSurface(int x, int z, int height, SurfaceContext ctx) {
        if (ctx.buffer.func_201576_a(Heightmap.Type.OCEAN_FLOOR_WG, x, z) == height) {
            BlockState state = this.getMaterial(x, z);
            ctx.buffer.func_177436_a((BlockPos)ctx.pos.func_181079_c(x, height, z), state, false);
        }
    }

    private BlockState getMaterial(int x, int z) {
        float value = this.noise.getValue(0, x, z);
        if ((double)value > 0.65) {
            if ((double)value < 0.725) {
                return (BlockState)States.PODZOL.get();
            }
            return (BlockState)States.DIRT.get();
        }
        return (BlockState)States.GRASS_BLOCK.get();
    }
}

