/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.provider;

import com.terraforged.engine.cell.Cell;
import com.terraforged.engine.concurrent.Resource;
import com.terraforged.engine.world.biome.DesertBiomes;
import com.terraforged.engine.world.biome.map.BiomeMap;
import com.terraforged.engine.world.biome.modifier.BeachModifier;
import com.terraforged.engine.world.biome.modifier.BiomeModifier;
import com.terraforged.engine.world.biome.modifier.CoastModifier;
import com.terraforged.engine.world.biome.modifier.DesertColorModifier;
import com.terraforged.engine.world.biome.modifier.DesertWetlandModifier;
import com.terraforged.engine.world.biome.modifier.ModifierManager;
import com.terraforged.engine.world.biome.modifier.MountainModifier;
import com.terraforged.engine.world.biome.modifier.OceanModifier;
import com.terraforged.engine.world.biome.modifier.VolcanoModifier;
import com.terraforged.engine.world.biome.modifier.WarmLakeModifier;
import com.terraforged.engine.world.biome.modifier.WetlandModifier;
import com.terraforged.engine.world.biome.type.BiomeType;
import com.terraforged.engine.world.heightmap.Levels;
import com.terraforged.mod.biome.ModBiomes;
import com.terraforged.mod.biome.context.TFBiomeContext;
import com.terraforged.mod.biome.provider.BiomeHelper;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.chunk.util.DummyBlockReader;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;

public class BiomeModifierManager
implements BiomeModifier {
    private final DesertBiomes desertBiomes;
    private final BiomeModifier[] modifiers;

    private BiomeModifierManager(Builder builder) {
        this.desertBiomes = builder.desertBiomes;
        this.modifiers = (BiomeModifier[])builder.modifiers.stream().sorted().toArray(BiomeModifier[]::new);
    }

    public boolean hasModifiers(Cell cell, Levels levels) {
        return cell.terrain.isOverground() || cell.terrain.isSubmerged() && cell.value > levels.water;
    }

    public DesertBiomes getDesertBiomes() {
        return this.desertBiomes;
    }

    @Override
    public int priority() {
        return -1;
    }

    @Override
    public boolean test(int biome, Cell cell) {
        return true;
    }

    @Override
    public int modify(int biome, Cell cell, int x, int z) {
        for (BiomeModifier modifier : this.modifiers) {
            if (!modifier.test(biome, cell)) continue;
            int result = modifier.modify(biome, cell, x, z);
            if (BiomeMap.isValid(result)) {
                biome = result;
            }
            if (!modifier.exitEarly()) continue;
            return biome;
        }
        return biome;
    }

    private static BeachModifier getBeachModifier(TerraContext context, BiomeMap biomes) {
        return new BeachModifier(biomes, context, context.biomeContext.biomes.getId((RegistryKey<Biome>)Biomes.field_76789_p), context.biomeContext.biomes.getId((RegistryKey<Biome>)Biomes.field_76788_q));
    }

    private static DesertBiomes getDesertBiomes(TFBiomeContext context, BiomeMap biomes) {
        IntArrayList redSand = new IntArrayList();
        IntArrayList whiteSand = new IntArrayList();
        IntList deserts = biomes.getAllBiomes(BiomeType.DESERT);
        int defaultRed = context.biomes.getId((RegistryKey<Biome>)Biomes.field_150589_Z);
        int defaultWhite = context.biomes.getId((RegistryKey<Biome>)Biomes.field_76769_d);
        try (Resource<DummyBlockReader> reader = DummyBlockReader.pooled();){
            IntListIterator intListIterator = deserts.iterator();
            while (intListIterator.hasNext()) {
                int redDist2;
                ISurfaceBuilderConfig config;
                Biome biome;
                BiomeGenerationSettings settings;
                int id = (Integer)intListIterator.next();
                if (!BiomeMap.isValid(id) || (settings = BiomeHelper.getGenSettings(biome = context.biomes.get(id))) == null || (config = settings.func_242502_e()) == null) continue;
                BlockState top = config.func_204108_a();
                MaterialColor color = top.func_185909_g((IBlockReader)reader.get().set(top), BlockPos.field_177992_a);
                int whiteDist2 = BiomeModifierManager.distance2(color, MaterialColor.field_151658_d);
                if (whiteDist2 < (redDist2 = BiomeModifierManager.distance2(color, MaterialColor.field_151667_k))) {
                    whiteSand.add(id);
                    continue;
                }
                redSand.add(id);
            }
        }
        return new DesertBiomes(deserts, (IntList)redSand, (IntList)whiteSand, defaultRed, defaultWhite, biomes.getContext());
    }

    private static int distance2(MaterialColor mc1, MaterialColor mc2) {
        Color c1 = new Color(mc1.field_76291_p);
        Color c2 = new Color(mc2.field_76291_p);
        int dr = c1.getRed() - c2.getRed();
        int dg = c1.getGreen() - c2.getGreen();
        int db = c1.getBlue() - c2.getBlue();
        return dr * dr + dg * dg + db * db;
    }

    public static Builder builder(TerraContext context, BiomeMap<RegistryKey<Biome>> biomes) {
        return new Builder(context, biomes);
    }

    public static class Builder
    implements ModifierManager {
        private final DesertBiomes desertBiomes;
        private final List<BiomeModifier> modifiers = new ArrayList<BiomeModifier>();

        private Builder(TerraContext context, BiomeMap<RegistryKey<Biome>> biomes) {
            this.desertBiomes = BiomeModifierManager.getDesertBiomes(context.biomeContext, biomes);
            this.modifiers.add(new OceanModifier(context, biomes));
            this.modifiers.add(BiomeModifierManager.getBeachModifier(context, biomes));
            this.modifiers.add(new CoastModifier(context, biomes));
            this.modifiers.add(new DesertColorModifier(this.desertBiomes));
            this.modifiers.add(new DesertWetlandModifier(biomes));
            this.modifiers.add(new WetlandModifier(biomes.getContext(), ModBiomes.MARSHLAND, ModBiomes.COLD_MARSHLAND, ModBiomes.FROZEN_MARSH));
            this.modifiers.add(new WarmLakeModifier(biomes.getContext(), Biomes.field_185442_R, ModBiomes.LAKE));
            this.modifiers.add(new MountainModifier(context, biomes, context.terraSettings.miscellaneous.mountainBiomeUsage));
            this.modifiers.add(new VolcanoModifier(biomes, context.terraSettings.miscellaneous.volcanoBiomeUsage));
        }

        @Override
        public void register(BiomeModifier modifier) {
            this.modifiers.add(modifier);
        }

        public BiomeModifierManager build() {
            return new BiomeModifierManager(this);
        }
    }
}

