/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.context;

import com.terraforged.engine.cell.Cell;
import com.terraforged.engine.world.biome.map.defaults.DefaultBiome;
import com.terraforged.engine.world.biome.map.defaults.DefaultBiomeSelector;
import com.terraforged.mod.biome.ModBiomes;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;

public class TFDefaultBiomes {
    public static final DefaultBiome.Factory<RegistryKey<Biome>> BEACH = context -> new DefaultBiomeSelector(context.getId(Biomes.field_150577_O), context.getId(Biomes.field_76787_r), context.getId(ModBiomes.WARM_BEACH), 0.25f, 0.75f);
    public static final DefaultBiome.Factory<RegistryKey<Biome>> COAST = context -> new DefaultBiomeSelector(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 0.25f, 0.75f);
    public static final DefaultBiome.Factory<RegistryKey<Biome>> RIVER = context -> new DefaultBiomeSelector(context.getId(Biomes.field_76777_m), context.getId(Biomes.field_76781_i), context.getId(Biomes.field_76781_i), 0.15f, 1.0f);
    public static final DefaultBiome.Factory<RegistryKey<Biome>> LAKE = context -> new DefaultBiomeSelector(context.getId(ModBiomes.FROZEN_LAKE), context.getId(ModBiomes.LAKE), context.getId(ModBiomes.LAKE), 0.15f, 1.0f);
    public static final DefaultBiome.Factory<RegistryKey<Biome>> WETLAND = context -> new DefaultBiomeSelector(context.getId(ModBiomes.COLD_MARSHLAND), context.getId(ModBiomes.MARSHLAND), context.getId(Biomes.field_76780_h), 0.4f, 1.0f){

        @Override
        public int getDefaultBiome(Cell cell) {
            if (cell.temperature > 0.25f) {
                if (cell.moisture > 0.65f) {
                    return this.warm;
                }
                if (cell.moisture > 0.4f) {
                    return this.medium;
                }
            }
            return this.getNone();
        }
    };
    public static final DefaultBiome.Factory<RegistryKey<Biome>> OCEAN = context -> new DefaultBiomeSelector(context.getId(Biomes.field_76776_l), context.getId(Biomes.field_76771_b), context.getId(Biomes.field_203614_T), 0.15f, 1.0f);
    public static final DefaultBiome.Factory<RegistryKey<Biome>> DEEP_OCEAN = context -> new DefaultBiomeSelector(context.getId(Biomes.field_203620_Z), context.getId(Biomes.field_150575_M), context.getId(Biomes.field_203617_W), 0.15f, 1.0f);
    public static final DefaultBiome.Factory<RegistryKey<Biome>> MOUNTAIN = context -> new DefaultBiomeSelector(context.getId(Biomes.field_76775_o), Integer.MIN_VALUE, Integer.MIN_VALUE, 0.25f, 1.0f);
    public static final DefaultBiome.Factory<RegistryKey<Biome>> VOLCANOES = context -> new DefaultBiomeSelector(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 0.25f, 1.0f);
    public static final DefaultBiome.Factory<RegistryKey<Biome>> LAND = context -> new DefaultBiomeSelector(context.getId(ModBiomes.TAIGA_SCRUB), context.getId(Biomes.field_76772_c), context.getId(ModBiomes.SAVANNA_SCRUB), 0.3f, 1.7f);

    public static boolean overridesRiver(Biome biome) {
        return biome.func_201856_r() == Biome.Category.SWAMP || biome.func_201856_r() == Biome.Category.JUNGLE;
    }
}

