/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.context;

import com.terraforged.engine.world.biome.TempCategory;
import com.terraforged.engine.world.biome.map.BiomeContext;
import com.terraforged.mod.biome.context.TFBiomeContext;
import com.terraforged.mod.biome.provider.BiomeHelper;
import java.util.function.Function;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;

public class BiomeProperties
implements BiomeContext.Properties<RegistryKey<Biome>> {
    private final TFBiomeContext context;

    public BiomeProperties(TFBiomeContext context) {
        this.context = context;
    }

    @Override
    public BiomeContext<RegistryKey<Biome>> getContext() {
        return this.context;
    }

    @Override
    public float getDepth(RegistryKey<Biome> key) {
        Biome biome = this.context.biomes.get(key);
        return biome.func_185355_j();
    }

    @Override
    public float getMoisture(RegistryKey<Biome> key) {
        Biome biome = this.context.biomes.get(key);
        return biome.func_76727_i();
    }

    @Override
    public float getTemperature(RegistryKey<Biome> key) {
        Biome biome = this.context.biomes.get(key);
        return biome.func_242445_k();
    }

    @Override
    public TempCategory getTempCategory(RegistryKey<Biome> key) {
        Biome biome = this.context.biomes.get(key);
        return BiomeHelper.getTempCategory(biome, this.context);
    }

    @Override
    public TempCategory getMountainCategory(RegistryKey<Biome> key) {
        Biome biome = this.context.biomes.get(key);
        return BiomeHelper.getMountainCategory(biome);
    }

    public <P> P getProperty(int id, Function<Biome, P> getter) {
        Biome biome = this.context.biomes.get(id);
        return getter.apply(biome);
    }
}

