/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.item.impl;

import cofh.core.util.ProxyUtils;
import cofh.lib.item.IColorableItem;
import cofh.lib.util.constants.Constants;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpawnEggItemCoFH
extends SpawnEggItem
implements IColorableItem {
    private static final Set<SpawnEggItemCoFH> EGG_ITEMS = new ObjectOpenHashSet();
    protected BooleanSupplier showInGroups = Constants.TRUE;
    private final int primaryColor;
    private final int secondaryColor;
    private final Supplier<EntityType<?>> typeSup;

    public SpawnEggItemCoFH(Supplier<EntityType<?>> typeSupIn, int primaryColorIn, int secondaryColorIn, Item.Properties builder) {
        super(typeSupIn.get(), primaryColorIn, secondaryColorIn, builder);
        this.typeSup = typeSupIn;
        this.primaryColor = primaryColorIn;
        this.secondaryColor = secondaryColorIn;
        ProxyUtils.registerColorable((Item)this);
        field_195987_b.remove(typeSupIn.get());
        EGG_ITEMS.add(this);
    }

    public static void setup() {
        for (SpawnEggItemCoFH egg : EGG_ITEMS) {
            field_195987_b.put(egg.typeSup.get(), egg);
        }
    }

    public SpawnEggItemCoFH setShowInGroups(BooleanSupplier showInGroups) {
        this.showInGroups = showInGroups;
        return this;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.showInGroups.getAsBoolean()) {
            return;
        }
        super.func_150895_a(group, items);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getColor(ItemStack item, int colorIndex) {
        return colorIndex == 0 ? this.primaryColor : this.secondaryColor;
    }

    public EntityType<?> func_208076_b(@Nullable CompoundNBT tag) {
        CompoundNBT compoundnbt;
        if (tag != null && tag.func_150297_b("EntityTag", 10) && (compoundnbt = tag.func_74775_l("EntityTag")).func_150297_b("id", 8)) {
            return EntityType.func_220327_a((String)compoundnbt.func_74779_i("id")).orElse(this.typeSup.get());
        }
        return this.typeSup.get();
    }
}

