/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.item.impl;

import cofh.lib.capability.templates.AreaEffectMiningItemWrapper;
import cofh.lib.item.ICoFHItem;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.constants.ToolTypes;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class SickleItem
extends ToolItem
implements ICoFHItem {
    protected BooleanSupplier showInGroups = Constants.TRUE;
    protected Supplier<ItemGroup> displayGroup;
    public static final Set<Block> EFFECTIVE_BLOCKS = ImmutableSet.of();
    public static final Set<Material> EFFECTIVE_MATERIALS = ImmutableSet.of((Object)Material.field_151584_j, (Object)Material.field_151585_k, (Object)Material.field_151582_l, (Object)Material.field_151569_G);
    private static final float DEFAULT_ATTACK_DAMAGE = 2.5f;
    private static final float DEFAULT_ATTACK_SPEED = -2.6f;
    private static final int DEFAULT_BASE_RADIUS = 2;
    private static final int DEFAULT_BASE_HEIGHT = 0;
    private final int radius;
    private final int height;

    public SickleItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, int radius, int height, Item.Properties builder) {
        super(attackDamageIn, attackSpeedIn, tier, EFFECTIVE_BLOCKS, builder.addToolType(ToolTypes.SICKLE, tier.func_200925_d()).func_200918_c(tier.func_200926_a() * 4));
        this.radius = radius;
        this.height = height;
    }

    public SickleItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        this(tier, attackDamageIn, attackSpeedIn, 2, 0, builder.addToolType(ToolTypes.SICKLE, tier.func_200925_d()));
    }

    public SickleItem(IItemTier tier, float attackDamageIn, Item.Properties builder) {
        this(tier, attackDamageIn, -2.6f, 2, 0, builder.addToolType(ToolTypes.SICKLE, tier.func_200925_d()));
    }

    public SickleItem(IItemTier tier, Item.Properties builder) {
        this(tier, 2.5f, -2.6f, 2, 0, builder.addToolType(ToolTypes.SICKLE, tier.func_200925_d()));
    }

    public SickleItem setDisplayGroup(Supplier<ItemGroup> displayGroup) {
        this.displayGroup = displayGroup;
        return this;
    }

    public SickleItem setShowInGroups(BooleanSupplier showInGroups) {
        this.showInGroups = showInGroups;
        return this;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.showInGroups.getAsBoolean() || this.displayGroup != null && this.displayGroup.get() != null && this.displayGroup.get() != group) {
            return;
        }
        super.func_150895_a(group, items);
    }

    public Collection<ItemGroup> getCreativeTabs() {
        return this.displayGroup != null && this.displayGroup.get() != null ? Collections.singletonList(this.displayGroup.get()) : super.getCreativeTabs();
    }

    public boolean func_150897_b(BlockState state) {
        if (state.getHarvestTool() == ToolTypes.SICKLE) {
            return this.func_200891_e().func_200925_d() >= state.getHarvestLevel();
        }
        return EFFECTIVE_MATERIALS.contains(state.func_185904_a());
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entity) {
        if (!world.field_72995_K && !state.func_177230_c().func_203417_a((ITag)BlockTags.field_232872_am_)) {
            stack.func_222118_a(1, entity, p_220036_0_ -> p_220036_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return EFFECTIVE_MATERIALS.contains(state.func_185904_a());
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_196553_aF) {
            return 15.0f;
        }
        return EFFECTIVE_MATERIALS.contains(state.func_185904_a()) ? this.field_77864_a : 1.0f;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new AreaEffectMiningItemWrapper(stack, this.radius, this.height, AreaEffectMiningItemWrapper.Type.SICKLE);
    }
}

