/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.item.impl;

import cofh.lib.item.ICoFHItem;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.Constants;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class ArrowItemCoFH
extends ArrowItem
implements ICoFHItem {
    protected BooleanSupplier showInGroups = Constants.TRUE;
    protected Supplier<ItemGroup> displayGroup;
    protected final IArrowFactory<? extends AbstractArrowEntity> factory;
    protected boolean infinitySupport = false;
    private static final ProjectileDispenseBehavior DISPENSER_BEHAVIOR = new ProjectileDispenseBehavior(){

        protected ProjectileEntity func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
            ArrowItemCoFH arrowItem = (ArrowItemCoFH)stackIn.func_77973_b();
            AbstractArrowEntity arrow = arrowItem.factory.createArrow(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            arrow.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
            return arrow;
        }
    };

    public ArrowItemCoFH(IArrowFactory<? extends AbstractArrowEntity> factory, Item.Properties builder) {
        super(builder);
        this.factory = factory;
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)DISPENSER_BEHAVIOR);
    }

    public ArrowItemCoFH setDisplayGroup(Supplier<ItemGroup> displayGroup) {
        this.displayGroup = displayGroup;
        return this;
    }

    public ArrowItemCoFH setShowInGroups(BooleanSupplier showInGroups) {
        this.showInGroups = showInGroups;
        return this;
    }

    public ArrowItemCoFH setInfinitySupport(boolean infinitySupport) {
        this.infinitySupport = infinitySupport;
        return this;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.showInGroups.getAsBoolean() || this.displayGroup != null && this.displayGroup.get() != null && this.displayGroup.get() != group) {
            return;
        }
        super.func_150895_a(group, items);
    }

    public Collection<ItemGroup> getCreativeTabs() {
        return this.displayGroup != null && this.displayGroup.get() != null ? Collections.singletonList(this.displayGroup.get()) : super.getCreativeTabs();
    }

    public AbstractArrowEntity func_200887_a(World worldIn, ItemStack stack, LivingEntity shooter) {
        return this.factory.createArrow(worldIn, shooter);
    }

    public boolean isInfinite(ItemStack stack, ItemStack bow, PlayerEntity player) {
        return this.infinitySupport && Utils.getItemEnchantmentLevel(Enchantments.field_185312_x, bow) > 0 || super.isInfinite(stack, bow, player);
    }

    public static interface IArrowFactory<T extends AbstractArrowEntity> {
        public T createArrow(World var1, LivingEntity var2);

        public T createArrow(World var1, double var2, double var4, double var6);
    }
}

