/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory;

import cofh.lib.inventory.SimpleItemInv;
import cofh.lib.util.helpers.MathHelper;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public interface IInventoryContainerItem {
    default public CompoundNBT getOrCreateInvTag(ItemStack container) {
        return container.func_190925_c("ItemInv");
    }

    public SimpleItemInv getContainerInventory(ItemStack var1);

    public int getContainerSlots(ItemStack var1);

    public void onContainerInventoryChanged(ItemStack var1);

    default public int getSpace(ItemStack container, int slot) {
        return this.getSlotLimit(container, slot) - this.getItemAmount(container, slot);
    }

    default public int getScaledItemsStored(ItemStack container, int slot, int scale) {
        return MathHelper.round((double)this.getItemAmount(container, slot) * (double)scale / (double)this.getSlotLimit(container, slot));
    }

    default public int getItemAmount(ItemStack container, int slot) {
        return this.getStackInSlot(container, slot).func_190916_E();
    }

    @Nonnull
    default public ItemStack getStackInSlot(ItemStack container, int slot) {
        return this.getContainerInventory(container).getStackInSlot(slot);
    }

    @Nonnull
    default public ItemStack insertItem(ItemStack container, int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.getContainerInventory(container).insertItem(slot, stack, simulate);
    }

    @Nonnull
    default public ItemStack extractItem(ItemStack container, int slot, int amount, boolean simulate) {
        return this.getContainerInventory(container).extractItem(slot, amount, simulate);
    }

    default public int getSlotLimit(ItemStack container, int slot) {
        return this.getContainerInventory(container).getSlotLimit(slot);
    }

    default public boolean isItemValid(ItemStack container, int slot, @Nonnull ItemStack stack) {
        return this.getContainerInventory(container).isItemValid(slot, stack);
    }
}

