/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.core.fluid.PotionFluid;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.references.CoreReferences;
import cofh.lib.util.references.FluidTagsCoFH;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class FluidHelper {
    public static final Predicate<FluidStack> IS_WATER = e -> e.getFluid().equals(Fluids.field_204546_a);
    public static final Predicate<FluidStack> IS_LAVA = e -> e.getFluid().equals(Fluids.field_204547_b);
    public static final Predicate<FluidStack> IS_XP = e -> FluidTagsCoFH.EXPERIENCE.func_230235_a_((Object)e.getFluid());
    public static final Map<Item, Function<ItemStack, FluidStack>> BOTTLE_DRAIN_MAP = new Object2ObjectOpenHashMap();
    public static final Map<Predicate<FluidStack>, Function<FluidStack, ItemStack>> BOTTLE_FILL_MAP = new Object2ObjectOpenHashMap();
    public static final IFormattableTextComponent EMPTY_POTION = new TranslationTextComponent("effect.none").func_240699_a_(TextFormatting.GRAY);

    private FluidHelper() {
    }

    public static int fluidHashcodeNoTag(FluidStack stack) {
        return stack.getFluid().hashCode();
    }

    public static int fluidHashcode(FluidStack stack) {
        return stack.getTag() != null ? stack.getFluid().hashCode() + 31 * stack.getTag().hashCode() : stack.getFluid().hashCode();
    }

    public static boolean fluidsEqual(FluidStack resourceA, FluidStack resourceB) {
        return resourceA != null && resourceA.isFluidEqual(resourceB) || resourceA == null && resourceB == null;
    }

    public static boolean fluidsEqual(Fluid fluidA, FluidStack resourceB) {
        return fluidA != null && resourceB != null && fluidA == resourceB.getFluid();
    }

    public static boolean fluidsEqual(FluidStack resourceA, Fluid fluidB) {
        return fluidB != null && resourceA != null && fluidB == resourceA.getFluid();
    }

    public static boolean fluidsEqual(Fluid fluidA, Fluid fluidB) {
        return fluidA != null && fluidA.equals(fluidB);
    }

    public static boolean isWater(BlockState state) {
        return state.func_177230_c() == Blocks.field_150355_j;
    }

    public static boolean extractFromAdjacent(TileEntity tile, FluidStorageCoFH tank, int amount, Direction side) {
        Direction opposite;
        amount = Math.min(amount, tank.getSpace());
        if (!tank.getFluidStack().isEmpty()) {
            return FluidHelper.extractFromAdjacent(tile, tank, new FluidStack(tank.getFluidStack(), amount), side);
        }
        TileEntity adjTile = BlockHelper.getAdjacentTileEntity(tile, side);
        IFluidHandler handler = FluidHelper.getFluidHandlerCap(adjTile, opposite = side.func_176734_d());
        if (handler == EmptyFluidHandler.INSTANCE) {
            return false;
        }
        FluidStack drainStack = handler.drain(amount, IFluidHandler.FluidAction.SIMULATE);
        int drainAmount = tank.fill(drainStack, IFluidHandler.FluidAction.EXECUTE);
        if (drainAmount > 0) {
            handler.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    public static boolean extractFromAdjacent(TileEntity tile, FluidStorageCoFH tank, FluidStack resource, Direction side) {
        Direction opposite;
        TileEntity adjTile = BlockHelper.getAdjacentTileEntity(tile, side);
        IFluidHandler handler = FluidHelper.getFluidHandlerCap(adjTile, opposite = side.func_176734_d());
        if (handler == EmptyFluidHandler.INSTANCE) {
            return false;
        }
        FluidStack drainStack = handler.drain(resource, IFluidHandler.FluidAction.SIMULATE);
        int drainAmount = tank.fill(drainStack, IFluidHandler.FluidAction.EXECUTE);
        if (drainAmount > 0) {
            handler.drain(new FluidStack(resource, drainAmount), IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    public static boolean insertIntoAdjacent(TileEntity tile, FluidStorageCoFH tank, int amount, Direction side) {
        Direction opposite;
        if (tank.isEmpty()) {
            return false;
        }
        amount = Math.min(amount, tank.getAmount());
        TileEntity adjTile = BlockHelper.getAdjacentTileEntity(tile, side);
        IFluidHandler handler = FluidHelper.getFluidHandlerCap(adjTile, opposite = side.func_176734_d());
        if (handler == EmptyFluidHandler.INSTANCE) {
            return false;
        }
        int fillAmount = handler.fill(new FluidStack(tank.getFluidStack(), amount), IFluidHandler.FluidAction.EXECUTE);
        if (fillAmount > 0) {
            tank.drain(fillAmount, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    public static boolean hasFluidHandlerCap(TileEntity tile, Direction face) {
        return tile != null && tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face).isPresent();
    }

    public static IFluidHandler getFluidHandlerCap(TileEntity tile, Direction face) {
        return tile == null ? EmptyFluidHandler.INSTANCE : (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face).orElse((Object)EmptyFluidHandler.INSTANCE);
    }

    public static void init() {
        BOTTLE_DRAIN_MAP.put(Items.field_151068_bn, stack -> PotionFluid.getPotionFluidFromItem(250, stack));
        BOTTLE_DRAIN_MAP.put(Items.field_226638_pX_, stack -> new FluidStack((Fluid)CoreReferences.FLUID_HONEY, 250));
        BOTTLE_DRAIN_MAP.put(Items.field_151062_by, stack -> new FluidStack((Fluid)CoreReferences.FLUID_XP, 250));
        BOTTLE_FILL_MAP.put(fluid -> fluid.getFluid() == Fluids.field_204546_a || FluidHelper.hasPotionTag(fluid), fluid -> PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)FluidHelper.getPotionFromFluid(fluid)));
        BOTTLE_FILL_MAP.put(fluid -> fluid.getFluid().func_207185_a(FluidTagsCoFH.HONEY), fluid -> new ItemStack((IItemProvider)Items.field_226638_pX_));
        BOTTLE_FILL_MAP.put(fluid -> fluid.getFluid().func_207185_a(FluidTagsCoFH.EXPERIENCE), fluid -> new ItemStack((IItemProvider)Items.field_151062_by));
    }

    public static boolean hasFluidHandlerCap(ItemStack item) {
        return !item.func_190926_b() && item.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent();
    }

    public static LazyOptional<IFluidHandlerItem> getFluidHandlerCap(@Nonnull ItemStack stack) {
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
    }

    public static Optional<FluidStack> getFluidContainedInItem(@Nonnull ItemStack container) {
        Optional fluidContained;
        if (!container.func_190926_b() && (fluidContained = FluidHelper.getFluidHandlerCap(container).map(c -> c.getFluidInTank(0))).isPresent() && !((FluidStack)fluidContained.get()).isEmpty()) {
            return fluidContained;
        }
        return Optional.empty();
    }

    public static int getCapacityForItem(@Nonnull ItemStack container) {
        if (!container.func_190926_b()) {
            return FluidHelper.getFluidHandlerCap(container).map(c -> c.getTankCapacity(0)).orElse(0);
        }
        return 0;
    }

    public static boolean drainBottleToHandler(ItemStack stack, IFluidHandler handler, PlayerEntity player, Hand hand) {
        FluidStack fluid = BOTTLE_DRAIN_MAP.containsKey(stack.func_77973_b()) ? BOTTLE_DRAIN_MAP.get(stack.func_77973_b()).apply(stack) : FluidStack.EMPTY;
        return !fluid.isEmpty() && FluidHelper.addEmptyBottleToPlayer(stack, fluid, handler, player, hand);
    }

    private static boolean addEmptyBottleToPlayer(ItemStack stack, FluidStack fluid, IFluidHandler handler, PlayerEntity player, Hand hand) {
        if (handler.fill(fluid, IFluidHandler.FluidAction.SIMULATE) == 250) {
            handler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
            if (!player.field_71075_bZ.field_75098_d) {
                ItemStack bottle = new ItemStack((IItemProvider)Items.field_151069_bo);
                player.func_184611_a(hand, ItemHelper.consumeItem(stack, 1));
                if (!player.func_191521_c(bottle)) {
                    player.func_71019_a(bottle, false);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean fillBottleFromHandler(ItemStack stack, IFluidHandler handler, PlayerEntity player, Hand hand) {
        if (stack.func_77973_b() != Items.field_151069_bo) {
            return false;
        }
        FluidStack fluid = handler.drain(250, IFluidHandler.FluidAction.SIMULATE);
        if (fluid.getAmount() != 250) {
            return false;
        }
        ItemStack bottle = ItemStack.field_190927_a;
        for (Map.Entry<Predicate<FluidStack>, Function<FluidStack, ItemStack>> entry : BOTTLE_FILL_MAP.entrySet()) {
            if (!entry.getKey().test(fluid)) continue;
            bottle = entry.getValue().apply(fluid);
            break;
        }
        return !bottle.func_190926_b() && FluidHelper.addFilledBottleToPlayer(stack, bottle, handler, player, hand);
    }

    public static boolean bucketFillTest(ItemStack stack, IFluidHandler handler) {
        if (stack.func_77973_b() != Items.field_151133_ar) {
            return true;
        }
        FluidStack fluid = handler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
        if (fluid.getAmount() != 1000) {
            return false;
        }
        return fluid.getFluid().func_204524_b() != Items.field_190931_a;
    }

    private static boolean addFilledBottleToPlayer(ItemStack stack, ItemStack bottle, IFluidHandler handler, PlayerEntity player, Hand hand) {
        if (handler.drain(250, IFluidHandler.FluidAction.EXECUTE).getAmount() == 250) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(hand, ItemHelper.consumeItem(stack, 1));
                if (!player.func_191521_c(bottle)) {
                    player.func_71019_a(bottle, false);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean drainItemToHandler(ItemStack stack, IFluidHandler handler, PlayerEntity player, Hand hand) {
        if (stack.func_190926_b() || handler == null || player == null) {
            return false;
        }
        if (FluidHelper.drainBottleToHandler(stack, handler, player, hand)) {
            player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), SoundEvents.field_191241_J, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        InvWrapper playerInv = new InvWrapper((IInventory)player.field_71071_by);
        FluidActionResult result = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)handler, (IItemHandler)playerInv, (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)true);
        if (result.isSuccess()) {
            player.func_184611_a(hand, result.getResult());
            return true;
        }
        return false;
    }

    public static boolean fillItemFromHandler(ItemStack stack, IFluidHandler handler, PlayerEntity player, Hand hand) {
        InvWrapper playerInv;
        FluidActionResult result;
        if (stack.func_190926_b() || handler == null || player == null || !FluidHelper.bucketFillTest(stack, handler)) {
            return false;
        }
        if (FluidHelper.fillBottleFromHandler(stack, handler, player, hand)) {
            player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (stack.func_190916_E() == 1) {
            FluidStack containedFluid = FluidHelper.getFluidContainedInItem(stack).orElse(FluidStack.EMPTY);
            int tankSpace = FluidHelper.getCapacityForItem(stack) - containedFluid.getAmount();
            if (!containedFluid.isEmpty() && tankSpace > 0) {
                stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(e -> {
                    if (player.field_71075_bZ.field_75098_d) {
                        handler.drain(new FluidStack(containedFluid, tankSpace), IFluidHandler.FluidAction.EXECUTE);
                    } else {
                        FluidUtil.tryFluidTransfer((IFluidHandler)e, (IFluidHandler)handler, (FluidStack)new FluidStack(containedFluid, tankSpace), (boolean)true);
                    }
                });
                return true;
            }
        }
        if ((result = FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)handler, (IItemHandler)(playerInv = new InvWrapper((IInventory)player.field_71071_by)), (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)true)).isSuccess()) {
            player.func_184611_a(hand, result.getResult());
            return true;
        }
        return false;
    }

    public static boolean interactWithHandler(ItemStack stack, IFluidHandler handler, PlayerEntity player, Hand hand) {
        return FluidHelper.drainItemToHandler(stack, handler, player, hand) || FluidHelper.fillItemFromHandler(stack, handler, player, hand);
    }

    public static boolean hasPotionTag(FluidStack stack) {
        return !stack.isEmpty() && stack.getTag() != null && stack.getTag().func_74764_b("Potion");
    }

    public static Potion getPotionFromFluid(FluidStack fluid) {
        return fluid.getFluid() == Fluids.field_204546_a ? Potions.field_185230_b : FluidHelper.getPotionFromFluidTag(fluid.getTag());
    }

    public static Potion getPotionFromFluidTag(@Nullable CompoundNBT tag) {
        return tag == null || !tag.func_74764_b("Potion") ? Potions.field_185229_a : Potion.func_185168_a((String)tag.func_74779_i("Potion"));
    }

    public static void addPotionTooltipStrings(FluidStack stack, List<ITextComponent> list) {
        ArrayList<ITextComponent> lores = new ArrayList<ITextComponent>();
        FluidHelper.addPotionTooltip(stack, lores, 1.0f);
        list.addAll(lores);
    }

    public static void addPotionTooltip(FluidStack stack, List<ITextComponent> list) {
        FluidHelper.addPotionTooltip(stack, list, 1.0f);
    }

    public static void addPotionTooltip(FluidStack stack, List<ITextComponent> lores, float durationFactor) {
        if (stack.isEmpty()) {
            return;
        }
        FluidHelper.addPotionTooltip(PotionUtils.func_185185_a((CompoundNBT)stack.getTag()), lores, durationFactor);
    }

    public static void addPotionTooltip(List<EffectInstance> list, List<ITextComponent> lores, float durationFactor) {
        ArrayList<Pair> list1 = new ArrayList<Pair>();
        if (list.isEmpty()) {
            lores.add((ITextComponent)EMPTY_POTION);
        } else {
            for (EffectInstance effectinstance : list) {
                TranslationTextComponent iformattabletextcomponent = new TranslationTextComponent(effectinstance.func_76453_d());
                Effect effect = effectinstance.func_188419_a();
                Map map = effect.func_111186_k();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), effect.func_111183_a(effectinstance.func_76458_c(), attributemodifier), attributemodifier.func_220375_c());
                        list1.add(new Pair(entry.getKey(), (Object)attributemodifier1));
                    }
                }
                if (effectinstance.func_76458_c() > 0) {
                    iformattabletextcomponent = new TranslationTextComponent("potion.withAmplifier", new Object[]{iformattabletextcomponent, new TranslationTextComponent("potion.potency." + effectinstance.func_76458_c())});
                }
                if (effectinstance.func_76459_b() > 20) {
                    iformattabletextcomponent = new TranslationTextComponent("potion.withDuration", new Object[]{iformattabletextcomponent, EffectUtils.func_188410_a((EffectInstance)effectinstance, (float)durationFactor)});
                }
                lores.add((ITextComponent)iformattabletextcomponent.func_240699_a_(effect.func_220303_e().func_220306_a()));
            }
        }
        if (!list1.isEmpty()) {
            lores.add(StringTextComponent.field_240750_d_);
            lores.add((ITextComponent)new TranslationTextComponent("potion.whenDrank").func_240699_a_(TextFormatting.DARK_PURPLE));
            for (Pair pair : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier2.func_111164_d();
                double d1 = attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                if (d0 > 0.0) {
                    lores.add((ITextComponent)new TranslationTextComponent("attribute.modifier.plus." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1), new TranslationTextComponent(((Attribute)pair.getFirst()).func_233754_c_())}).func_240699_a_(TextFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lores.add((ITextComponent)new TranslationTextComponent("attribute.modifier.take." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), new TranslationTextComponent(((Attribute)pair.getFirst()).func_233754_c_())}).func_240699_a_(TextFormatting.RED));
            }
        }
    }

    public static int color(FluidStack stack) {
        return !stack.isEmpty() && stack.getFluid() != null ? stack.getFluid().getAttributes().getColor(stack) : 0;
    }

    public static int luminosity(FluidStack stack) {
        return !stack.isEmpty() && stack.getFluid() != null ? stack.getFluid().getAttributes().getLuminosity(stack) : 0;
    }

    public static int density(FluidStack stack) {
        return !stack.isEmpty() && stack.getFluid() != null ? stack.getFluid().getAttributes().getDensity(stack) : 0;
    }

    public static boolean gaseous(FluidStack stack) {
        return !stack.isEmpty() && stack.getFluid() != null && stack.getFluid().getAttributes().isGaseous();
    }

    public static int temperature(FluidStack stack) {
        return !stack.isEmpty() && stack.getFluid() != null ? stack.getFluid().getAttributes().getTemperature(stack) : 0;
    }

    public static int viscosity(FluidStack stack) {
        return !stack.isEmpty() && stack.getFluid() != null ? stack.getFluid().getAttributes().getViscosity(stack) : 0;
    }
}

