/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle;

import cofh.core.client.particle.LevelMatrixStackParticle;
import cofh.core.util.helpers.vfx.RenderTypes;
import cofh.core.util.helpers.vfx.VFXHelper;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.SplittableRandom;
import javax.annotation.Nullable;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WindVortexParticle
extends LevelMatrixStackParticle {
    protected static final float defaultLifetime = 8.0f;
    protected float fLifetime;
    protected int seed;
    protected float scale;
    protected float height;

    private WindVortexParticle(ClientWorld level, double xPos, double yPos, double zPos, double speed, double width, double height) {
        super(level, xPos, yPos, zPos, speed, width, height);
        this.fLifetime = 8.0f / (float)speed;
        this.field_70547_e = MathHelper.ceil(this.fLifetime * 1.2f);
        this.seed = this.field_187136_p.nextInt();
        this.func_187115_a((float)(width * (1.0 + this.field_187136_p.nextGaussian() * (double)0.1f)), (float)height * this.field_187136_p.nextFloat());
        this.field_190017_n = false;
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
        this.field_82339_as = 0.2f * (1.0f + this.field_187136_p.nextFloat());
        this.field_70553_i = this.field_70551_j = 1.0f - 0.1f * this.field_187136_p.nextFloat();
        this.field_70552_h = this.field_70551_j;
        this.field_190015_G = this.field_190014_F = this.field_187136_p.nextFloat() * ((float)Math.PI * 2);
    }

    @Override
    public void render(MatrixStack stack, IRenderTypeBuffer buffer, int packedLight, float partialTicks) {
        SplittableRandom rand = new SplittableRandom(this.seed);
        float time = (float)this.field_70546_d + partialTicks - (float)rand.nextDouble(this.fLifetime * 0.2f);
        if (time < 0.0f || time > this.fLifetime) {
            return;
        }
        float progress = time / this.fLifetime;
        float easeSin = 1.0f - MathHelper.sin(progress * (float)Math.PI * 0.5f);
        float easePlat = MathHelper.easePlateau(progress);
        float a = this.field_82339_as * easePlat;
        float halfHeight = 0.5f * this.field_187135_o;
        stack.func_227862_a_(this.field_187134_n, halfHeight, this.field_187134_n);
        stack.func_227860_a_();
        float hScale = easeSin + 0.5f;
        if (halfHeight > 0.0f) {
            stack.func_227861_a_(0.0, rand.nextDouble(-halfHeight, halfHeight), 0.0);
        }
        stack.func_227862_a_(hScale, 2.0f, hScale);
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(this.field_190014_F + progress * (float)rand.nextDouble(2.0, 3.0)));
        Vector4f[] poss = new Vector4f[rand.nextInt(10, 20)];
        for (int i = 0; i < poss.length; ++i) {
            float rot = (float)i * 0.1309f;
            float r = 0.95f + (float)i * 0.08f;
            poss[i] = new Vector4f(r * MathHelper.cos(rot), easeSin + (float)i * 0.05f, r * MathHelper.sin(rot), 1.0f);
        }
        VFXHelper.renderStreamLine(stack, buffer.getBuffer(RenderTypes.FLAT_TRANSLUCENT), packedLight, poss, VFXHelper.packRGBA(this.field_70552_h, this.field_70553_i, this.field_70551_j, a), VFXHelper.getWidthFunc((float)rand.nextDouble(0.02f, 0.04f)));
        stack.func_227865_b_();
        VFXHelper.renderCyclone(stack, buffer.getBuffer(RenderTypes.FLAT_TRANSLUCENT), packedLight, 1, (float)rand.nextDouble(0.02f, 0.04f), progress * 0.5f + (float)rand.nextDouble(420.0), a);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        public Factory(IAnimatedSprite sprite) {
        }

        @Nullable
        public Particle createParticle(BasicParticleType data, ClientWorld world, double x, double y, double z, double speed, double width, double height) {
            return new WindVortexParticle(world, x, y, z, speed, width, height);
        }
    }
}

