/*
 * Decompiled with CFR 0.152.
 */
package com.mgen256.al.blocks;

import com.mgen256.al.AdditionalLights;
import com.mgen256.al.FireTypes;
import com.mgen256.al.ModBlockList;
import com.mgen256.al.ModSoundList;
import com.mgen256.al.PedestalTypes;
import com.mgen256.al.blocks.FireBase;
import com.mgen256.al.blocks.FirePitBase;
import com.mgen256.al.blocks.IHasFire;
import com.mgen256.al.blocks.ModBlock;
import com.mgen256.al.items.SoulWand;
import com.mgen256.al.items.Wand;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class Pedestal
extends ModBlock
implements IWaterLoggable,
IHasFire {
    public static BooleanProperty ACCEPT_POWER = BooleanProperty.func_177716_a((String)"accept_power");
    public static BooleanProperty ISPOWERED = BooleanProperty.func_177716_a((String)"ispowered");
    public static BooleanProperty ACTIVATED = BooleanProperty.func_177716_a((String)"activated");
    private static StringTextComponent txt_shift;
    private static StringTextComponent txt_tips;
    private static StringTextComponent txt_rightclick;
    private static StringTextComponent txt_sneaking;
    private static StringTextComponent txt_signals;
    private static SoundEvent ignitionSound;

    private static AbstractBlock.Properties createProps(Block mainblock) {
        BlockState state = mainblock.func_176223_P();
        Material mbm = state.func_185904_a();
        return AbstractBlock.Properties.func_200949_a((Material)mbm, (MaterialColor)state.func_185909_g(null, null)).harvestTool(state.getHarvestTool()).harvestLevel(state.getHarvestLevel()).func_200948_a(state.func_185887_b(null, null), state.getExplosionResistance(null, null, null)).func_200947_a(state.getSoundType(null, null, null));
    }

    public Pedestal(String basename, Block mainblock, VoxelShape shape) {
        super(basename, mainblock, Pedestal.createProps(mainblock), shape);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FIRE_TYPE, (Comparable)((Object)FireTypes.NORMAL))).func_206870_a((Property)PREVIOUS_FIRE_TYPE, (Comparable)((Object)FireTypes.NORMAL))).func_206870_a((Property)ACCEPT_POWER, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)ISPOWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
        if (ignitionSound == null) {
            ignitionSound = basename.contains("_l_") ? AdditionalLights.modSounds.get((Object)ModSoundList.Fire_Ignition_L) : AdditionalLights.modSounds.get((Object)ModSoundList.Fire_Ignition_S);
        }
    }

    protected abstract ModBlockList getFireKey(BlockState var1);

    public abstract PedestalTypes getType();

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208198_y});
        builder.func_206894_a(new Property[]{FIRE_TYPE});
        builder.func_206894_a(new Property[]{PREVIOUS_FIRE_TYPE});
        builder.func_206894_a(new Property[]{ACCEPT_POWER});
        builder.func_206894_a(new Property[]{ISPOWERED});
        builder.func_206894_a(new Property[]{ACTIVATED});
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return true;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    private Block getFireBlock(BlockState state) {
        return AdditionalLights.getBlock(this.getFireKey(state));
    }

    public boolean setFire(World worldIn, BlockPos pos, BlockState state, boolean replaceOnly) {
        BlockPos upperpos = pos.func_177984_a();
        BlockState upperBlockState = worldIn.func_180495_p(upperpos);
        Block upperblock = upperBlockState.func_177230_c();
        FireBase firebase = null;
        if (upperblock instanceof FireBase) {
            firebase = (FireBase)upperblock;
        }
        if (replaceOnly ? firebase == null : !(upperBlockState.func_196958_f() || upperBlockState.func_185904_a() == Material.field_151586_h || firebase != null)) {
            return false;
        }
        if (firebase != null && !((Boolean)worldIn.func_180495_p(upperpos).getBlockState().func_177229_b((Property)FireBase.SUMMONED)).booleanValue()) {
            worldIn.func_175655_b(upperpos, true);
        }
        return worldIn.func_175656_a(upperpos, (BlockState)((BlockState)this.getFireBlock(state).func_176223_P().func_206870_a((Property)FireBase.SET, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FireBase.SUMMONED, (Comparable)Boolean.valueOf(true)));
    }

    public void RemoveFire(World worldIn, BlockPos pos, BlockState state) {
        BlockState upperBlockState = worldIn.func_180495_p(pos.func_177984_a());
        if (!(upperBlockState.func_177230_c() instanceof FireBase)) {
            return;
        }
        worldIn.func_175656_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (handIn == Hand.OFF_HAND) {
            return ActionResultType.PASS;
        }
        ItemStack stack = player.func_184586_b(handIn);
        if (stack.func_77973_b() instanceof Wand) {
            return ActionResultType.FAIL;
        }
        if (!this.setFire(worldIn, pos, state, false)) {
            return ActionResultType.PASS;
        }
        Pedestal.playIgnitionSound(worldIn, player, state.func_177230_c(), pos);
        return ActionResultType.SUCCESS;
    }

    private static void playIgnitionSound(World worldIn, PlayerEntity player, Block block, BlockPos pos) {
        float volume = block instanceof FirePitBase ? 2.0f : 1.5f;
        worldIn.func_184133_a(player, pos, ignitionSound, SoundCategory.BLOCKS, volume, 1.0f);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer.func_184592_cb().func_77973_b() instanceof SoulWand) {
            state = (BlockState)state.func_206870_a((Property)FIRE_TYPE, (Comparable)((Object)FireTypes.SOUL));
        }
        if (placer.func_225608_bj_()) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)ACCEPT_POWER, (Comparable)Boolean.valueOf(false)));
        } else {
            worldIn.func_175656_a(pos, state);
            this.setFire(worldIn, pos, state, false);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        state = worldIn.func_180495_p(pos);
        if (!((Boolean)state.func_177229_b((Property)ACCEPT_POWER)).booleanValue()) {
            return;
        }
        if (worldIn.func_175640_z(pos)) {
            if (((Boolean)state.func_177229_b((Property)ACTIVATED)).booleanValue()) {
                return;
            }
            if (this.setFire(worldIn, pos, state, false)) {
                Pedestal.playIgnitionSound(worldIn, null, state.func_177230_c(), pos);
            }
            worldIn.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)ISPOWERED, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)ACTIVATED, (Comparable)Boolean.valueOf(true)));
        } else if (((Boolean)state.func_177229_b((Property)ISPOWERED)).booleanValue() && ((Boolean)state.func_177229_b((Property)ACTIVATED)).booleanValue()) {
            this.RemoveFire(worldIn, pos, state);
            worldIn.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)ISPOWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (txt_shift == null) {
            if (!I18n.func_188566_a((String)"additional_lights.txt.shift")) {
                return;
            }
            txt_shift = new StringTextComponent(I18n.func_135052_a((String)"additional_lights.txt.shift", (Object[])new Object[0]));
            txt_tips = new StringTextComponent(I18n.func_135052_a((String)"additional_lights.txt.tips", (Object[])new Object[0]));
            txt_rightclick = new StringTextComponent(I18n.func_135052_a((String)"additional_lights.txt.block.pedestal.rightclick", (Object[])new Object[0]));
            txt_sneaking = new StringTextComponent(I18n.func_135052_a((String)"additional_lights.txt.block.pedestal.sneaking", (Object[])new Object[0]));
            txt_signals = new StringTextComponent(I18n.func_135052_a((String)"additional_lights.txt.block.pedestal.signals", (Object[])new Object[0]));
        }
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)txt_tips);
            tooltip.add((ITextComponent)txt_rightclick);
            tooltip.add((ITextComponent)txt_sneaking);
            tooltip.add((ITextComponent)txt_signals);
        } else {
            tooltip.add((ITextComponent)txt_shift);
        }
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

