/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.util;

import com.google.common.hash.Hashing;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import org.apache.commons.io.FilenameUtils;

public class TextureDownloader {
    public static void downloadTexture(URL url, String path, @Nullable TextureAvailableCallback textureAvailableCallback) {
        Runnable runnable = () -> Minecraft.func_71410_x().execute(() -> RenderSystem.recordRenderCall(() -> {
            String s = Hashing.sha1().hashUnencodedChars((CharSequence)FilenameUtils.getBaseName((String)url.toString())).toString();
            ResourceLocation resourceLocation = new ResourceLocation("valhelsia_core", path + s);
            TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
            Texture texture = textureManager.func_229267_b_(resourceLocation);
            if (texture == null) {
                try {
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
                    InputStream stream = connection.getInputStream();
                    NativeImage image = NativeImage.func_195713_a((InputStream)stream);
                    textureManager.func_229263_a_(resourceLocation, (Texture)new DynamicTexture(image));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (textureAvailableCallback != null) {
                textureAvailableCallback.onTextureAvailable(resourceLocation);
            }
        }));
        Util.func_215072_e().execute(runnable);
    }

    public static interface TextureAvailableCallback {
        public void onTextureAvailable(ResourceLocation var1);
    }
}

