/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.valhelsia.valhelsia_core.client.CosmeticsManager;

public class UpdateCosmeticsPacket {
    private final UUID uuid;
    private final CompoundNBT activeCosmetics;

    public UpdateCosmeticsPacket(UUID uuid, CompoundNBT activeCosmetics) {
        this.uuid = uuid;
        this.activeCosmetics = activeCosmetics;
    }

    public static void encode(UpdateCosmeticsPacket packet, PacketBuffer buffer) {
        buffer.func_179252_a(packet.uuid);
        buffer.func_150786_a(packet.activeCosmetics);
    }

    public static UpdateCosmeticsPacket decode(PacketBuffer buffer) {
        return new UpdateCosmeticsPacket(buffer.func_179253_g(), buffer.func_150793_b());
    }

    public static void consume(UpdateCosmeticsPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                CosmeticsManager cosmeticsManager = CosmeticsManager.getInstance();
                cosmeticsManager.setActiveCosmeticsForPlayer(packet.uuid, packet.activeCosmetics);
                cosmeticsManager.tryLoadCosmeticsForPlayer(packet.uuid, null);
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

