/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client;

import javax.annotation.Nullable;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.valhelsia.valhelsia_core.client.Cosmetic;

public enum CosmeticsCategory {
    HAT("hat"),
    BACK("back"),
    HAND("hand"),
    FACE("face"),
    SPECIAL("special");

    private final String name;
    private final TranslationTextComponent component;
    public ForgeConfigSpec.ConfigValue<String> activeCosmetic;

    private CosmeticsCategory(String name) {
        this.name = name;
        this.component = new TranslationTextComponent("cosmetic.valhelsia_core.category." + name);
    }

    public String getName() {
        return this.name;
    }

    public TranslationTextComponent getComponent() {
        return this.component;
    }

    @Nullable
    public Cosmetic getActiveCosmetic() {
        return ((String)this.activeCosmetic.get()).equals("") ? null : new Cosmetic((String)this.activeCosmetic.get(), this);
    }

    public void setActiveCosmetic(String name) {
        this.activeCosmetic.set((Object)name);
    }

    public static CosmeticsCategory getForCosmetic(String cosmeticName) {
        if (cosmeticName.contains("hat")) {
            return HAT;
        }
        if (cosmeticName.contains("cape")) {
            return BACK;
        }
        if (cosmeticName.contains("witchs_wand")) {
            return HAND;
        }
        if (cosmeticName.equals("cauldron_backpack")) {
            return BACK;
        }
        if (cosmeticName.equals("witchs_broom")) {
            return SPECIAL;
        }
        if (cosmeticName.contains("beanie")) {
            return HAT;
        }
        if (cosmeticName.contains("scarf")) {
            return FACE;
        }
        return null;
    }
}

