/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.HollowMicroblock;
import codechicken.multipart.api.MultiPartType;
import codechicken.multipart.api.NormalOcclusionTest;
import codechicken.multipart.api.RedstoneInteractions;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.api.part.TNormalOcclusionPart;
import codechicken.multipart.api.part.TSlottedPart;
import codechicken.multipart.api.part.redstone.IRedstonePart;
import codechicken.multipart.block.BlockMultiPart;
import codechicken.multipart.block.TileMultiPart;
import codechicken.multipart.util.PartRayTraceResult;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import mrtjp.projectred.core.PlacementLib;
import mrtjp.projectred.core.client.HaloRenderer;
import mrtjp.projectred.illumination.MultipartLightProperties;
import net.minecraft.block.SoundType;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MultipartLightPart
extends TMultiPart
implements TSlottedPart,
TNormalOcclusionPart,
IRedstonePart {
    private final MultiPartType<?> type;
    private final MultipartLightProperties properties;
    private final int color;
    private final boolean inverted;
    protected boolean powered = false;
    protected int side = 0;

    public MultipartLightPart(MultiPartType<?> type, MultipartLightProperties properties, int color, boolean inverted) {
        this.type = type;
        this.properties = properties;
        this.color = color;
        this.inverted = inverted;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public int getSide() {
        return this.side;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isLightOn() {
        return this.powered != this.inverted;
    }

    public void preparePlacement(int side) {
        this.side = side;
    }

    public void save(CompoundNBT tag) {
        tag.func_74757_a("pow", this.powered);
        tag.func_74774_a("side", (byte)this.side);
    }

    public void load(CompoundNBT tag) {
        this.powered = tag.func_74767_n("pow");
        this.side = tag.func_74771_c("side") & 0xFF;
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte(this.side).writeBoolean(this.powered);
    }

    public void readDesc(MCDataInput packet) {
        this.side = packet.readUByte();
        this.powered = packet.readBoolean();
    }

    public void readUpdate(MCDataInput packet) {
        this.readDesc(packet);
        this.updateRender();
    }

    public void onNeighborBlockChanged(BlockPos from) {
        if (this.checkSupport()) {
            return;
        }
        this.updateState(false);
    }

    public void onPartChanged(TMultiPart part) {
        if (this.checkSupport()) {
            return;
        }
        this.updateState(false);
    }

    public void onAdded() {
        if (this.checkSupport()) {
            return;
        }
        this.updateState(true);
    }

    public int getLightValue() {
        return this.isInverted() != this.powered ? 15 : 0;
    }

    private ItemStack getItem() {
        return this.properties.makeStack(this.color, this.inverted);
    }

    private boolean checkSupport() {
        if (this.world().field_72995_K) {
            return false;
        }
        if (this.properties.canFloat()) {
            return false;
        }
        BlockPos bc = this.pos().func_177972_a(Direction.values()[this.side]);
        if (MultipartLightPart.canPlaceLight(this.world(), bc, Direction.values()[this.side ^ 1])) {
            return false;
        }
        TileMultiPart.dropItem((ItemStack)this.getItem(), (World)this.world(), (Vector3)Vector3.fromTileCenter((TileEntity)this.tile()));
        this.tile().remPart((TMultiPart)this);
        return true;
    }

    private boolean checkPower() {
        for (int s = 0; s < 6; ++s) {
            if (s == (this.side ^ 1) || RedstoneInteractions.getPowerTo((TMultiPart)this, (int)s) <= 0) continue;
            return true;
        }
        return false;
    }

    private void updateState(boolean forceRender) {
        boolean updated = false;
        if (!this.world().field_72995_K) {
            boolean oldPower = this.powered;
            this.powered = this.checkPower();
            if (oldPower != this.powered) {
                updated = true;
                this.updateRender();
            }
        }
        if (forceRender && !updated) {
            this.updateRender();
        }
    }

    private void updateRender() {
        if (!this.world().field_72995_K) {
            this.sendUpdate(this::writeDesc);
        }
        this.tile().recalcLight(false, true);
        this.tile().markRender();
    }

    public boolean occlusionTest(TMultiPart npart) {
        return NormalOcclusionTest.test((TNormalOcclusionPart)this, (TMultiPart)npart) && super.occlusionTest(npart);
    }

    public VoxelShape getShape(ISelectionContext context) {
        return this.properties.getShape(this.side);
    }

    public VoxelShape getOcclusionShape() {
        return this.getShape(ISelectionContext.func_216377_a());
    }

    public MultiPartType<?> getType() {
        return this.type;
    }

    public float getStrength(PlayerEntity player, PartRayTraceResult hit) {
        return 0.06666667f;
    }

    public int getSlotMask() {
        return 64;
    }

    public Iterable<ItemStack> getDrops() {
        return Collections.singletonList(this.getItem());
    }

    public ItemStack pickItem(PartRayTraceResult hit) {
        return this.getItem();
    }

    public boolean canConnectRedstone(int side) {
        return true;
    }

    public int strongPowerLevel(int side) {
        return 0;
    }

    public int weakPowerLevel(int side) {
        return 0;
    }

    public SoundType getPlacementSound(ItemUseContext context) {
        return SoundType.field_185853_f;
    }

    public boolean renderStatic(RenderType layer, CCRenderState ccrs) {
        if (layer == null || layer == RenderType.func_228643_e_()) {
            ccrs.setBrightness((IBlockDisplayReader)this.world(), this.pos());
            this.properties.render(this, Vector3.ZERO, ccrs);
            return true;
        }
        return false;
    }

    public void renderDynamic(MatrixStack mStack, IRenderTypeBuffer buffers, int packedLight, int packedOverlay, float partialTicks) {
        if (this.isLightOn()) {
            HaloRenderer.renderHalo((CCRenderState)CCRenderState.instance(), (MatrixStack)mStack, (IRenderTypeBuffer)buffers, (Cuboid6)this.properties.getGlowBounds(this.getSide()), (int)this.getColor(), (Vector3)Vector3.ZERO);
        }
    }

    public static boolean canPlaceLight(World world, BlockPos pos, Direction side) {
        if (PlacementLib.canPlaceLight((World)world, (BlockPos)pos, (Direction)side)) {
            return true;
        }
        TMultiPart part = BlockMultiPart.getPart((IBlockReader)world, (BlockPos)pos, (int)side.ordinal());
        return part instanceof HollowMicroblock;
    }
}

