/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination.part;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.RedundantTransformation;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.HollowMicroblock;
import codechicken.microblock.Microblock;
import codechicken.microblock.MicroblockClient;
import codechicken.microblock.api.BlockMicroMaterial;
import codechicken.multipart.block.TileMultiPart;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.LinkedList;
import java.util.function.Supplier;
import mrtjp.projectred.core.client.HaloRenderer;
import mrtjp.projectred.illumination.block.IllumarLampBlock;
import mrtjp.projectred.illumination.part.IllumarLampMicroblockMixinMarker;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;

public class IllumarLampMicroMaterial
extends BlockMicroMaterial
implements IllumarLampMicroblockMixinMarker {
    private final Supplier<Block> block;

    public IllumarLampMicroMaterial(Supplier<Block> block) {
        super(block.get().func_176223_P());
        this.block = block;
    }

    public int getLightColor() {
        return ((IllumarLampBlock)this.block.get()).getColor();
    }

    public boolean renderItem(CCRenderState ccrs, ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack mStack, IRenderTypeBuffer buffers, Matrix4 mat, MicroblockClient part) {
        ccrs.bind(Atlases.func_239280_i_(), buffers, mat);
        part.render(null, ccrs);
        MatrixStack stack2 = new MatrixStack();
        stack2.func_227866_c_().func_227870_a_().set(mat.toMatrix4f());
        this.renderHalo(ccrs, stack2, buffers, (Microblock)part);
        return true;
    }

    public void renderHalo(CCRenderState ccrs, MatrixStack mStack, IRenderTypeBuffer buffers, Microblock part) {
        LinkedList<Cuboid6> boxes = new LinkedList<Cuboid6>();
        if (part instanceof HollowMicroblock) {
            byte shape = part.shape();
            int size = ((HollowMicroblock)part).getHollowSize();
            double d1 = 0.5 - (double)size / 32.0;
            double d2 = 0.5 + (double)size / 32.0;
            double t = (double)(shape >> 4) / 8.0;
            double ex = 0.025;
            boxes.add(new Cuboid6(0.0 - ex, 0.0 - ex, 0.0 - ex, 1.0 + ex, t + ex, d1 + ex));
            boxes.add(new Cuboid6(0.0 - ex, 0.0 - ex, d2 - ex, 1.0 + ex, t + ex, 1.0 + ex));
            boxes.add(new Cuboid6(0.0 - ex, 0.0 - ex, d1 + ex, d1 + ex, t + ex, d2 - ex));
            boxes.add(new Cuboid6(d2 - ex, 0.0 - ex, d1 + ex, 1.0 + ex, t + ex, d2 - ex));
            Transformation tr = Rotation.sideRotations[shape & 0xF].at(Vector3.CENTER);
            boxes.forEach(b -> b.apply(tr));
        } else {
            boxes.add(part.getBounds().copy().expand(0.025));
        }
        HaloRenderer.prepareRenderState((CCRenderState)ccrs, (MatrixStack)mStack, (IRenderTypeBuffer)buffers);
        for (Cuboid6 box : boxes) {
            HaloRenderer.renderToCCRS((CCRenderState)ccrs, (Cuboid6)box, (int)this.getLightColor(), (Transformation)new RedundantTransformation());
        }
    }

    public int calculateLightLevel(TileMultiPart tile) {
        double lightVolume = tile.getPartList().stream().filter(p -> p instanceof Microblock).filter(p -> ((Microblock)p).getMaterial() instanceof IllumarLampMicroMaterial).mapToDouble(p -> ((Microblock)p).getBounds().volume()).sum();
        return (int)Math.min(15.0, 10.0 + 5.0 * lightVolume);
    }
}

