/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination.init;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.texture.SpriteRegistryHelper;
import codechicken.lib.util.SneakyUtils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import mrtjp.projectred.illumination.BlockLightType;
import mrtjp.projectred.illumination.MultipartLightType;
import mrtjp.projectred.illumination.client.IllumarLampItemRenderer;
import mrtjp.projectred.illumination.client.IllumarLampTileRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.resource.IResourceType;

public class IlluminationClientInit {
    public static void init() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(IlluminationClientInit::clientSetup);
        modEventBus.addListener(IlluminationClientInit::onModelRegistryEvent);
        SpriteRegistryHelper iconRegister = new SpriteRegistryHelper();
        for (MultipartLightType type : MultipartLightType.values()) {
            iconRegister.addIIconRegister(type.getProperties()::registerIcons);
        }
        ModelRegistryHelper modelHelper = new ModelRegistryHelper();
        modelHelper.registerCallback(e -> {
            for (int color = 0; color < 16; ++color) {
                ResourceLocation blockRL = BlockLightType.ILLUMAR_LAMP.getBlock(color, true).getRegistryName();
                IBakedModel litModel = (IBakedModel)e.getModelRegistry().get(new ModelResourceLocation(blockRL, "lit=true"));
                e.getModelRegistry().put(new ModelResourceLocation(blockRL, "inventory"), new IllumarLampItemRenderer(litModel));
            }
        });
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        for (BlockLightType lampType : BlockLightType.values()) {
            for (int color = 0; color < 16; ++color) {
                ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)SneakyUtils.unsafeCast(lampType.getTileEntityType(color, false))), IllumarLampTileRenderer::new);
                ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)SneakyUtils.unsafeCast(lampType.getTileEntityType(color, true))), IllumarLampTileRenderer::new);
            }
        }
    }

    private static void onModelRegistryEvent(ModelRegistryEvent event) {
        for (MultipartLightType type : MultipartLightType.values()) {
            ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("projectred-illumination", type.getUnlocalBaseName()), (IModelLoader)new GenericModelLoader(type.getProperties().getItemRenderer()));
        }
    }

    private static class GenericModelLoader
    implements IModelGeometry<GenericModelLoader>,
    IModelLoader<GenericModelLoader> {
        private final IItemRenderer renderer;

        public GenericModelLoader(IItemRenderer renderer) {
            this.renderer = renderer;
        }

        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
            return this.renderer;
        }

        public GenericModelLoader read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return this;
        }

        public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return Collections.emptyList();
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        }
    }
}

