/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination.data;

import mrtjp.projectred.illumination.BlockLightType;
import mrtjp.projectred.illumination.MultipartLightType;
import net.minecraft.data.DataGenerator;
import net.minecraftforge.common.data.LanguageProvider;

public class IlluminationLanguageProvider
extends LanguageProvider {
    private static final String[] LOCAL_COLORS = new String[]{"White", "Orange", "Magenta", "Light Blue", "Yellow", "Lime", "Pink", "Gray", "Light Gray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};

    public IlluminationLanguageProvider(DataGenerator gen) {
        super(gen, "projectred-illumination", "en_us");
    }

    protected void addTranslations() {
        int color;
        this.add("itemGroup.projectred-illumination", "Project Red: Illumination");
        for (BlockLightType blockLightType : BlockLightType.values()) {
            for (color = 0; color < 16; ++color) {
                this.add(blockLightType.getBlock(color, false), IlluminationLanguageProvider.createLocalizedLightName(color, false, blockLightType.getLocalBaseName()));
                this.add(blockLightType.getBlock(color, true), IlluminationLanguageProvider.createLocalizedLightName(color, true, blockLightType.getLocalBaseName()));
            }
        }
        for (Enum enum_ : MultipartLightType.values()) {
            for (color = 0; color < 16; ++color) {
                this.add(((MultipartLightType)enum_).getItem(color, false), IlluminationLanguageProvider.createLocalizedLightName(color, false, ((MultipartLightType)enum_).getLocalBaseName()));
                this.add(((MultipartLightType)enum_).getItem(color, true), IlluminationLanguageProvider.createLocalizedLightName(color, true, ((MultipartLightType)enum_).getLocalBaseName()));
            }
        }
    }

    public static String createLocalizedLightName(int color, boolean inverted, String lightName) {
        return LOCAL_COLORS[color] + (inverted ? " Inverted " : " ") + lightName;
    }
}

