/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination.client;

import codechicken.lib.model.bakedmodels.WrappedItemModel;
import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import mrtjp.projectred.core.client.HaloRenderer;
import mrtjp.projectred.illumination.block.IllumarLampBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;

public class IllumarLampItemRenderer
extends WrappedItemModel
implements IItemRenderer {
    private static final Cuboid6 BLOCK_BOUNDS = Cuboid6.full.copy().expand(-0.02);
    private static final Cuboid6 GLOW_BOUNDS = Cuboid6.full.copy().expand(0.02);
    private static final Random random = new Random();

    public IllumarLampItemRenderer(IBakedModel wrapped) {
        super(wrapped);
    }

    public void renderItem(ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack mStack, IRenderTypeBuffer getter, int packedLight, int packedOverlay) {
        Item item = stack.func_77973_b();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        if (!(blockItem.func_179223_d() instanceof IllumarLampBlock)) {
            return;
        }
        IllumarLampBlock block = (IllumarLampBlock)blockItem.func_179223_d();
        if (!block.isInverted()) {
            this.renderWrapped(stack, transformType, mStack, getter, packedLight, packedOverlay, false);
            return;
        }
        TextureAtlasSprite icon = ((BakedQuad)this.wrapped.func_200117_a(null, Direction.UP, random).get(0)).func_187508_a();
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        ccrs.bind(RenderType.func_228643_e_(), getter, mStack);
        ccrs.setPipeline(new IVertexOperation[]{new IconTransformation(icon)});
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)BLOCK_BOUNDS, (int)0);
        HaloRenderer.renderHalo((CCRenderState)ccrs, (MatrixStack)mStack, (IRenderTypeBuffer)getter, (Cuboid6)GLOW_BOUNDS, (int)block.getColor(), (Vector3)Vector3.ZERO);
    }

    public IModelTransform getModelTransform() {
        return TransformUtils.DEFAULT_BLOCK;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_230044_c_() {
        return true;
    }
}

