/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination.block;

import java.util.Random;
import javax.annotation.Nullable;
import mrtjp.projectred.illumination.tile.IllumarLampTile;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class IllumarLampBlock
extends Block {
    public static final BooleanProperty LIT = RedstoneTorchBlock.field_196528_a;
    private final int color;
    private final boolean inverted;

    public IllumarLampBlock(int color, boolean inverted) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151591_t).func_200943_b(0.5f).func_235838_a_(state -> (Boolean)state.func_177229_b((Property)LIT) != false ? 15 : 0));
        this.color = color;
        this.inverted = inverted;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(inverted)));
    }

    public int getColor() {
        return this.color;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a()) != this.inverted));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT});
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos neighbor, boolean isMoving) {
        boolean shouldBeLit;
        super.onNeighborChange(state, (IWorldReader)world, pos, neighbor);
        if (world.func_201670_d()) {
            return;
        }
        boolean isLit = (Boolean)state.func_177229_b((Property)LIT);
        boolean bl = shouldBeLit = world.func_175640_z(pos) != this.inverted;
        if (isLit != shouldBeLit && !world.func_205220_G_().func_205359_a(pos, (Object)this)) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, 2);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        boolean shouldBeLit;
        super.func_225534_a_(state, world, pos, rand);
        boolean isLit = (Boolean)state.func_177229_b((Property)LIT);
        boolean bl = shouldBeLit = world.func_175640_z(pos) != this.inverted;
        if (isLit != shouldBeLit) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(shouldBeLit)));
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new IllumarLampTile(this.color, this.inverted);
    }
}

