/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.gui.SimpleItemGroup;
import codechicken.lib.util.SneakyUtils;
import codechicken.multipart.api.MultiPartType;
import mrtjp.projectred.illumination.BlockLightType;
import mrtjp.projectred.illumination.data.IlluminationBlockLootProvider;
import mrtjp.projectred.illumination.data.IlluminationBlockStateModelProvider;
import mrtjp.projectred.illumination.data.IlluminationItemModelProvider;
import mrtjp.projectred.illumination.data.IlluminationLanguageProvider;
import mrtjp.projectred.illumination.data.IlluminationRecipeProvider;
import mrtjp.projectred.illumination.init.IlluminationBlocks;
import mrtjp.projectred.illumination.init.IlluminationClientInit;
import mrtjp.projectred.illumination.init.IlluminationMicroMaterials;
import mrtjp.projectred.illumination.init.IlluminationParts;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="projectred-illumination")
public class ProjectRedIllumination {
    public static final String MOD_ID = "projectred-illumination";
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"projectred-illumination");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"projectred-illumination");
    public static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"projectred-illumination");
    public static final DeferredRegister<MultiPartType<?>> PARTS = DeferredRegister.create((Class)((Class)SneakyUtils.unsafeCast(MultiPartType.class)), (String)"projectred-illumination");
    public static final SimpleItemGroup ILLUMINATION_GROUP = new SimpleItemGroup("projectred-illumination", () -> new ItemStack((IItemProvider)BlockLightType.ILLUMAR_LAMP.getBlock(EnumColour.RED.ordinal(), true)));

    public ProjectRedIllumination() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onGatherDataEvent);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> IlluminationClientInit::init);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        TILE_ENTITIES.register(modEventBus);
        PARTS.register(modEventBus);
        modEventBus.register((Object)new IlluminationMicroMaterials());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void onGatherDataEvent(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        if (event.includeClient()) {
            generator.func_200390_a((IDataProvider)new IlluminationBlockStateModelProvider(generator, fileHelper));
            generator.func_200390_a((IDataProvider)new IlluminationItemModelProvider(generator, fileHelper));
            generator.func_200390_a((IDataProvider)new IlluminationLanguageProvider(generator));
        }
        if (event.includeServer()) {
            generator.func_200390_a((IDataProvider)new IlluminationBlockLootProvider(generator));
            generator.func_200390_a((IDataProvider)new IlluminationRecipeProvider(generator));
        }
    }

    static {
        IlluminationBlocks.register();
        IlluminationParts.register();
        IlluminationMicroMaterials.register();
    }
}

