/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination;

import codechicken.lib.colour.EnumColour;
import codechicken.multipart.api.MultiPartType;
import codechicken.multipart.api.SimpleMultiPartType;
import java.util.ArrayList;
import java.util.List;
import mrtjp.projectred.illumination.MultipartLightProperties;
import mrtjp.projectred.illumination.item.MultipartLightPartItem;
import mrtjp.projectred.illumination.part.CageLightProperties;
import mrtjp.projectred.illumination.part.FalloutLightProperties;
import mrtjp.projectred.illumination.part.FixtureLightProperties;
import mrtjp.projectred.illumination.part.LanternLightProperties;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;

public enum MultipartLightType {
    FIXTURE("fixture_light", "Fixture Light", new FixtureLightProperties()),
    FALLOUT("fallout_light", "Fallout Light", new FalloutLightProperties()),
    CAGE("cage_light", "Cage Light", new CageLightProperties()),
    LANTERN("lantern", "Lantern", new LanternLightProperties());

    private final String unlocalName;
    private final String localName;
    private final MultipartLightProperties properties;
    private final List<RegistryObject<Item>> itemSuppliers = new ArrayList<RegistryObject<Item>>();
    private final List<RegistryObject<Item>> invertedItemSuppliers = new ArrayList<RegistryObject<Item>>();
    private final List<RegistryObject<MultiPartType<?>>> partSuppliers = new ArrayList();
    private final List<RegistryObject<MultiPartType<?>>> invertedPartSuppliers = new ArrayList();

    private MultipartLightType(String unlocalName, String localName, MultipartLightProperties properties) {
        this.unlocalName = unlocalName;
        this.localName = localName;
        this.properties = properties;
    }

    public MultipartLightProperties getProperties() {
        return this.properties;
    }

    public void registerParts(DeferredRegister<MultiPartType<?>> partRegistry, DeferredRegister<Item> itemRegistry) {
        int colorFinal;
        int color;
        for (color = 0; color < 16; ++color) {
            colorFinal = color;
            String regID = MultipartLightType.getRegistryID(this.unlocalName, color, false);
            this.itemSuppliers.add(color, (RegistryObject<Item>)itemRegistry.register(regID, () -> new MultipartLightPartItem(this.properties, colorFinal, false)));
            this.partSuppliers.add(color, partRegistry.register(regID, () -> new SimpleMultiPartType(isClient -> this.properties.partFactory(colorFinal, false))));
        }
        for (color = 0; color < 16; ++color) {
            colorFinal = color;
            String invRegID = MultipartLightType.getRegistryID(this.unlocalName, color, true);
            this.invertedItemSuppliers.add(color, (RegistryObject<Item>)itemRegistry.register(invRegID, () -> new MultipartLightPartItem(this.properties, colorFinal, true)));
            this.invertedPartSuppliers.add(color, partRegistry.register(invRegID, () -> new SimpleMultiPartType(isClient -> this.properties.partFactory(colorFinal, true))));
        }
    }

    public Item getItem(int color, boolean inverted) {
        return inverted ? (Item)this.invertedItemSuppliers.get(color).get() : (Item)this.itemSuppliers.get(color).get();
    }

    public ItemStack makeStack(int colour, boolean inverted) {
        Item item = (Item)(inverted ? this.invertedItemSuppliers : this.itemSuppliers).get(colour).get();
        return new ItemStack((IItemProvider)item);
    }

    public MultiPartType<?> getPartType(int color, boolean inverted) {
        return inverted ? (MultiPartType)this.invertedPartSuppliers.get(color).get() : (MultiPartType)this.partSuppliers.get(color).get();
    }

    public String getLocalBaseName() {
        return this.localName;
    }

    public String getUnlocalBaseName() {
        return this.unlocalName;
    }

    public String getRegistryID(int color, boolean inverted) {
        return MultipartLightType.getRegistryID(this.unlocalName, color, inverted);
    }

    private static String getRegistryID(String name, int color, boolean inverted) {
        return EnumColour.values()[color].func_176610_l() + (inverted ? "_inverted" : "") + "_" + name;
    }
}

