/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination;

import codechicken.lib.colour.EnumColour;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import mrtjp.projectred.illumination.ProjectRedIllumination;
import mrtjp.projectred.illumination.block.IllumarLampBlock;
import mrtjp.projectred.illumination.tile.IllumarLampTile;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.registries.DeferredRegister;

public enum BlockLightType {
    ILLUMAR_LAMP("illumar_lamp", "Illumar Lamp", IllumarLampBlock::new, IllumarLampTile::new);

    private final String unlocalName;
    private final String localName;
    private final BiFunction<Integer, Boolean, Block> blockFactory;
    private final BiFunction<Integer, Boolean, TileEntity> tileFactory;
    private final ArrayList<Supplier<Block>> blockSupplier = new ArrayList();
    private final ArrayList<Supplier<Block>> invertedBlockSupplier = new ArrayList();
    private final ArrayList<Supplier<Item>> itemBlockSupplier = new ArrayList();
    private final ArrayList<Supplier<Item>> invertedItemBlockSupplier = new ArrayList();
    private final ArrayList<Supplier<TileEntityType<?>>> tileEntityTypeSupplier = new ArrayList();
    private final ArrayList<Supplier<TileEntityType<?>>> invertedTileEntityTypeSupplier = new ArrayList();

    private BlockLightType(String unlocalName, String localName, BiFunction<Integer, Boolean, Block> blockFactory, BiFunction<Integer, Boolean, TileEntity> tileFactory) {
        this.unlocalName = unlocalName;
        this.localName = localName;
        this.blockFactory = blockFactory;
        this.tileFactory = tileFactory;
    }

    public void registerBlocks(DeferredRegister<Block> blockRegistry, DeferredRegister<Item> itemRegistry, DeferredRegister<TileEntityType<?>> tileRegistry) {
        int colorFinal;
        int color;
        for (color = 0; color < 16; ++color) {
            colorFinal = color;
            String registryID = this.getRegistryID(color, false);
            this.blockSupplier.add(color, (Supplier<Block>)blockRegistry.register(registryID, () -> this.blockFactory.apply(colorFinal, false)));
            this.itemBlockSupplier.add(color, (Supplier<Item>)itemRegistry.register(registryID, () -> new BlockItem(this.getBlock(colorFinal, false), new Item.Properties().func_200916_a((ItemGroup)ProjectRedIllumination.ILLUMINATION_GROUP))));
            this.tileEntityTypeSupplier.add(color, (Supplier<TileEntityType<?>>)tileRegistry.register(registryID, () -> TileEntityType.Builder.func_223042_a(() -> this.tileFactory.apply(colorFinal, false), (Block[])new Block[]{this.getBlock(colorFinal, false)}).func_206865_a(null)));
        }
        for (color = 0; color < 16; ++color) {
            colorFinal = color;
            String invertedRegistryID = this.getRegistryID(color, true);
            this.invertedBlockSupplier.add(color, (Supplier<Block>)blockRegistry.register(invertedRegistryID, () -> this.blockFactory.apply(colorFinal, true)));
            this.invertedItemBlockSupplier.add(color, (Supplier<Item>)itemRegistry.register(invertedRegistryID, () -> new BlockItem(this.getBlock(colorFinal, true), new Item.Properties().func_200916_a((ItemGroup)ProjectRedIllumination.ILLUMINATION_GROUP))));
            this.invertedTileEntityTypeSupplier.add(color, (Supplier<TileEntityType<?>>)tileRegistry.register(invertedRegistryID, () -> TileEntityType.Builder.func_223042_a(() -> this.tileFactory.apply(colorFinal, true), (Block[])new Block[]{this.getBlock(colorFinal, true)}).func_206865_a(null)));
        }
    }

    public Block getBlock(int color, boolean inverted) {
        return inverted ? this.invertedBlockSupplier.get(color).get() : this.blockSupplier.get(color).get();
    }

    public TileEntityType<?> getTileEntityType(int color, boolean inverted) {
        return inverted ? this.invertedTileEntityTypeSupplier.get(color).get() : this.tileEntityTypeSupplier.get(color).get();
    }

    public String getLocalBaseName() {
        return this.localName;
    }

    public String getRegistryID(int color, boolean inverted) {
        return EnumColour.values()[color].func_176610_l().toLowerCase() + (inverted ? "_inverted" : "") + "_" + this.unlocalName;
    }
}

