/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import quek.undergarden.entity.rotspawn.AbstractRotspawnEntity;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;

public class ScintlingEntity
extends AnimalEntity {
    public ScintlingEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new AvoidEntityGoal((CreatureEntity)this, AbstractRotspawnEntity.class, 12.0f, 1.2, 1.4));
        this.field_70714_bg.func_75776_a(1, (Goal)new TemptGoal((CreatureEntity)this, 1.5, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)UGItems.BLISTERBERRY.get()}), false));
        this.field_70714_bg.func_75776_a(1, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(1, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return AnimalEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 2.0).func_233815_a_(Attributes.field_233821_d_, 0.2);
    }

    public static boolean canScintlingSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == UGBlocks.DEPTHROCK.get() || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == UGBlocks.ASHEN_DEEPTURF_BLOCK.get();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) || this.func_70631_g_()) {
            return;
        }
        BlockState goo = ((Block)UGBlocks.GOO.get()).func_176223_P();
        for (int l = 0; l < 4; ++l) {
            int z;
            int y;
            int x = MathHelper.func_76128_c((double)(this.func_226277_ct_() + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
            BlockPos blockpos = new BlockPos(x, y = MathHelper.func_76128_c((double)this.func_226278_cu_()), z = MathHelper.func_76128_c((double)(this.func_226281_cx_() + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f))));
            if (!this.field_70170_p.func_175623_d(blockpos) || !goo.func_196955_c((IWorldReader)this.field_70170_p, blockpos)) continue;
            this.field_70170_p.func_175656_a(blockpos, goo);
        }
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return (AgeableEntity)((EntityType)UGEntityTypes.SCINTLING.get()).func_200721_a(this.field_70170_p);
    }

    public boolean func_70877_b(ItemStack stack) {
        return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)UGItems.BLISTERBERRY.get()}).test(stack);
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
    }
}

