/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.config.cave;

import com.yungnickyoung.minecraft.bettercaves.config.cave.ConfigCubicCave;
import com.yungnickyoung.minecraft.bettercaves.config.cave.ConfigSimplexCave;
import com.yungnickyoung.minecraft.bettercaves.config.cave.ConfigSurfaceCave;
import com.yungnickyoung.minecraft.bettercaves.config.cave.ConfigVanillaCave;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigCaves {
    public final ConfigCubicCave cubicCave;
    public final ConfigSimplexCave simplexCave;
    public final ConfigSurfaceCave surfaceCave;
    public final ConfigVanillaCave vanillaCave;
    public final ForgeConfigSpec.ConfigValue<Double> caveSpawnChance;
    public final ForgeConfigSpec.ConfigValue<String> caveRegionSize;
    public final ForgeConfigSpec.ConfigValue<Double> customRegionSize;

    public ConfigCaves(ForgeConfigSpec.Builder BUILDER) {
        BUILDER.comment("##########################################################################################################\n# Settings used in the generation of caves.\n##########################################################################################################").push("Caves");
        this.cubicCave = new ConfigCubicCave(BUILDER);
        this.simplexCave = new ConfigSimplexCave(BUILDER);
        this.surfaceCave = new ConfigSurfaceCave(BUILDER);
        this.vanillaCave = new ConfigVanillaCave(BUILDER);
        this.caveSpawnChance = BUILDER.comment(" Percent chance of caves spawning in a given region.\n Default: caves spawn in 100% of regions.").worldRestart().defineInRange("Cave Spawn Chance", 100.0, 0.0, 100.0);
        this.caveRegionSize = BUILDER.comment(" Determines how large cave regions are.\n     Controls the average size of a cave system.\n Accepted values: Small, Medium, Large, ExtraLarge, Custom\n Default: Small (recommended).").worldRestart().define("Cave Region Size", (Object)"Small");
        this.customRegionSize = BUILDER.comment(" Custom value for cave region size. Smaller value = larger regions. This value is very sensitive to change.\n     ONLY WORKS IF Cave Region Size IS Custom.\n     Provided values:\n         Small: 0.008\n         Medium: 0.005\n         Large: 0.0032\n         ExtraLarge: 0.001\n Default: 0.008").worldRestart().defineInRange("Cave Region Size Custom Value", (double)0.008f, 0.0, (double)0.05f);
        BUILDER.pop();
    }
}

