/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered_computercraft_integration;

import commoble.morered.api.ChanneledPowerSupplier;
import commoble.morered.api.MoreRedAPI;
import commoble.morered.plate_blocks.PlateBlockStateProperties;
import commoble.morered_computercraft_integration.MoreRedComputercraftIntegration;
import dan200.computercraft.api.ComputerCraftAPI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class MRCCAdapterBlockEntity
extends TileEntity {
    protected LazyOptional<ChanneledPowerSupplier> powerHolder = this.makePowerHolder();

    public MRCCAdapterBlockEntity() {
        super((TileEntityType)MoreRedComputercraftIntegration.INSTANCE.mrccAdapterBlockEntity.get());
    }

    public MRCCAdapterBlockEntity(TileEntityType<?> type) {
        super(type);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == MoreRedAPI.CHANNELED_POWER_CAPABILITY) {
            return side == PlateBlockStateProperties.getOutputDirection((BlockState)this.func_195044_w()) ? this.powerHolder : LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.powerHolder.invalidate();
    }

    public void resetCapabilities() {
        LazyOptional<ChanneledPowerSupplier> oldPowerHolder = this.powerHolder;
        this.powerHolder = this.makePowerHolder();
        oldPowerHolder.invalidate();
    }

    protected LazyOptional<ChanneledPowerSupplier> makePowerHolder() {
        return LazyOptional.of(() -> this::getPowerOnChannel);
    }

    public int getPowerOnChannel(@Nonnull World world, @Nonnull BlockPos wirePos, @Nonnull BlockState wireState, @Nullable Direction wireFace, int channel) {
        BlockState thisState = this.func_195044_w();
        Direction directionToMoreRed = PlateBlockStateProperties.getOutputDirection((BlockState)thisState);
        Direction directionToCC = directionToMoreRed.func_176734_d();
        BlockPos ccPos = this.field_174879_c.func_177972_a(directionToCC);
        int ccBundledRedstoneValue = ComputerCraftAPI.getBundledRedstoneOutput((World)world, (BlockPos)ccPos, (Direction)directionToMoreRed);
        return ccBundledRedstoneValue > 0 && (ccBundledRedstoneValue & 1 << channel) > 0 ? 31 : 0;
    }
}

