/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered_computercraft_integration;

import commoble.morered.api.ChanneledPowerSupplier;
import commoble.morered.api.MoreRedAPI;
import commoble.morered.plate_blocks.PlateBlock;
import commoble.morered.plate_blocks.PlateBlockStateProperties;
import commoble.morered.util.BlockStateUtil;
import commoble.morered.util.DirectionHelper;
import commoble.morered.wire_post.AbstractPostBlock;
import commoble.morered_computercraft_integration.MRCCAdapterBlockEntity;
import commoble.morered_computercraft_integration.MoreRedComputercraftIntegration;
import dan200.computercraft.shared.common.IBundledRedstoneBlock;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MRCCAdapterBlock
extends PlateBlock
implements IBundledRedstoneBlock {
    public static final VoxelShape[][] SHAPES_BY_ATTACHMENT_DIRECTION_AND_ROTATION = (VoxelShape[][])Util.func_199748_a(() -> {
        VoxelShape[][] finalShapes = new VoxelShape[6][4];
        VoxelShape[] attachmentPlateShapesByDirection = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.func_208617_a((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), Block.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
        VoxelShape[] backplateShapesByDirection = new VoxelShape[]{Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), Block.func_208617_a((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.func_208617_a((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)2.0), Block.func_208617_a((double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0, (double)16.0), Block.func_208617_a((double)0.0, (double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0), Block.func_208617_a((double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0)};
        for (Direction attachmentDirection : Direction.values()) {
            int attachmentDirectionIndex = attachmentDirection.ordinal();
            VoxelShape attachmentPlateShape = attachmentPlateShapesByDirection[attachmentDirectionIndex];
            for (int rotationIndex = 0; rotationIndex < 4; ++rotationIndex) {
                VoxelShape combinedShape;
                Direction inputDirection = BlockStateUtil.getOutputDirection((Direction)attachmentDirection, (int)rotationIndex).func_176734_d();
                int inputDirectionIndex = inputDirection.ordinal();
                VoxelShape backplateShape = backplateShapesByDirection[inputDirectionIndex];
                finalShapes[attachmentDirectionIndex][rotationIndex] = combinedShape = VoxelShapes.func_197872_a((VoxelShape)attachmentPlateShape, (VoxelShape)backplateShape);
            }
        }
        return finalShapes;
    });
    public static final VoxelShape[] DOUBLE_PLATE_SHAPES_BY_DIRECTION = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.func_208617_a((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), Block.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public MRCCAdapterBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)MoreRedComputercraftIntegration.INSTANCE.mrccAdapterBlockEntity.get()).func_200968_a();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (state.func_235901_b_((Property)PlateBlock.ATTACHMENT_DIRECTION) && state.func_235901_b_((Property)PlateBlock.ROTATION)) {
            return SHAPES_BY_ATTACHMENT_DIRECTION_AND_ROTATION[((Direction)state.func_177229_b((Property)ATTACHMENT_DIRECTION)).ordinal()][(Integer)state.func_177229_b((Property)PlateBlock.ROTATION)];
        }
        return SHAPES_BY_ATTACHMENT_DIRECTION_AND_ROTATION[0][0];
    }

    public boolean getBundledRedstoneConnectivity(World world, BlockPos pos, Direction side) {
        return PlateBlockStateProperties.getOutputDirection((BlockState)world.func_180495_p(pos)).func_176734_d() == side;
    }

    public int getBundledRedstoneOutput(World world, BlockPos thisPos, Direction sideOfThisBlock) {
        BlockPos moreRedNeighbor;
        TileEntity te;
        BlockState thisState = world.func_180495_p(thisPos);
        Direction moreRedSide = PlateBlockStateProperties.getOutputDirection((BlockState)thisState);
        Direction computerCraftSide = moreRedSide.func_176734_d();
        if (sideOfThisBlock == computerCraftSide && (te = world.func_175625_s(moreRedNeighbor = thisPos.func_177972_a(moreRedSide))) != null) {
            Direction attachmentSide = (Direction)thisState.func_177229_b((Property)PlateBlock.ATTACHMENT_DIRECTION);
            return te.getCapability(MoreRedAPI.CHANNELED_POWER_CAPABILITY, computerCraftSide).map(powerSupplier -> MRCCAdapterBlock.getBundledRedstoneValueFromPowerSupplier(powerSupplier, world, thisPos, thisState, attachmentSide)).orElse(0);
        }
        return 0;
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        Direction outputDirection;
        super.onNeighborChange(state, world, pos, neighbor);
        Direction updatePropagationDir = DirectionHelper.getDirectionToNeighborPos((BlockPos)neighbor, (BlockPos)pos);
        if (updatePropagationDir != null && (outputDirection = PlateBlockStateProperties.getOutputDirection((BlockState)world.func_180495_p(pos))).func_176740_k() == updatePropagationDir.func_176740_k()) {
            BlockPos nextNeighbor = pos.func_177972_a(updatePropagationDir);
            world.func_180495_p(nextNeighbor).onNeighborChange(world, nextNeighbor, pos);
        }
    }

    public boolean canConnectToAdjacentCable(@Nonnull IBlockReader world, @Nonnull BlockPos thisPos, @Nonnull BlockState thisState, @Nonnull BlockPos wirePos, @Nonnull BlockState wireState, @Nonnull Direction wireFace, @Nonnull Direction directionToWire) {
        Direction plateAttachmentDir = (Direction)thisState.func_177229_b((Property)AbstractPostBlock.DIRECTION_OF_ATTACHMENT);
        Direction moreRedSide = PlateBlockStateProperties.getOutputDirection((BlockState)thisState);
        return directionToWire == moreRedSide && plateAttachmentDir == wireFace;
    }

    @Deprecated
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity te;
        if (state.func_177230_c() == newState.func_177230_c() && state != newState && (te = worldIn.func_175625_s(pos)) instanceof MRCCAdapterBlockEntity) {
            ((MRCCAdapterBlockEntity)te).resetCapabilities();
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader world, List<ITextComponent> texts, ITooltipFlag flag) {
        super.func_190948_a(stack, world, texts, flag);
        texts.add((ITextComponent)new TranslationTextComponent("morered_computercraft_integration.tooltips.adapter").func_240699_a_(TextFormatting.GRAY));
    }

    public static int getBundledRedstoneValueFromPowerSupplier(ChanneledPowerSupplier powerSupplier, World world, BlockPos thisPos, BlockState thisState, Direction attachmentSide) {
        int result = 0;
        for (int channel = 0; channel < 16; ++channel) {
            if (powerSupplier.getPowerOnChannel(world, thisPos, thisState, attachmentSide, channel) <= 0) continue;
            result |= 1 << channel;
        }
        return result;
    }
}

