/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.core.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public final class EEConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    private static String makeTranslation(String name) {
        return "endergetic.config." + name;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class ValuesHolder {
        private static boolean debugDragonFightManager;

        public static void updateCommonValuesFromConfig(ModConfig config) {
            debugDragonFightManager = (Boolean)EEConfig.COMMON.debugDragonFightManager.get();
        }

        public static boolean shouldDebugDragonFightManager() {
            return debugDragonFightManager;
        }
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> debugDragonFightManager;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common only settings for Endergetic").push("common");
            this.debugDragonFightManager = builder.comment("If The Dragon Fight Manager should debug its portal values; Default: False").translation(EEConfig.makeTranslation("debug_dragon_fight_manager")).define("debugDragonFightManager", false);
            builder.pop();
        }
    }
}

