/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.util.modification;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.minecraftabnormals.abnormals_core.core.util.modification.IModifier;
import javax.annotation.Nullable;

public class ModifierRegistry<T, S, D> {
    private final BiMap<String, IModifier<T, ?, S, D>> modifiers = HashBiMap.create();

    public synchronized <C, M extends IModifier<T, C, S, D>> M register(String name, M modifier) {
        if (this.modifiers.containsKey((Object)name)) {
            throw new IllegalArgumentException("A modifier with name '" + name + "' is already registered!");
        }
        this.modifiers.put((Object)name, modifier);
        return modifier;
    }

    @Nullable
    public IModifier<T, ?, S, D> getModifier(String name) {
        return (IModifier)this.modifiers.get((Object)name);
    }

    @Nullable
    public String getName(IModifier<T, ?, S, D> modifier) {
        return (String)this.modifiers.inverse().get(modifier);
    }
}

