/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.endimator.entity;

import com.google.common.collect.Lists;
import com.minecraftabnormals.abnormals_core.core.endimator.Endimation;
import com.minecraftabnormals.abnormals_core.core.endimator.Endimator;
import com.minecraftabnormals.abnormals_core.core.endimator.entity.EndimatorModelRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class EndimatorEntityModel<E extends Entity>
extends EntityModel<E> {
    public List<EndimatorModelRenderer> savedBoxes = Lists.newArrayList();
    protected final Endimator<E> endimator = new Endimator();
    protected E entity;

    public void animateModel(E endimatedEntity) {
        this.endimator.tick(endimatedEntity);
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.animateModel(this.entity);
    }

    public void func_225597_a_(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.entity = entity;
        this.revertBoxesToDefaultValues();
    }

    public void addBoxToSavedBoxes(EndimatorModelRenderer box) {
        this.savedBoxes.add(box);
    }

    public void setDefaultBoxValues() {
        this.savedBoxes.forEach(EndimatorModelRenderer::setDefaultBoxValues);
    }

    public void revertBoxesToDefaultValues() {
        this.savedBoxes.forEach(EndimatorModelRenderer::revertToDefaultBoxValues);
    }

    public void setEndimationToPlay(Endimation endimationToPlay) {
        this.endimator.setEndimationToPlay(endimationToPlay);
    }

    public boolean tryToPlayEndimation(Endimation endimationToPlay) {
        return this.endimator.tryToPlayEndimation(endimationToPlay);
    }

    public void startKeyframe(int tickDuration) {
        this.endimator.startKeyframe(tickDuration);
    }

    public void setStaticKeyframe(int tickDuration) {
        this.endimator.setStaticKeyframe(tickDuration);
    }

    public void endKeyframe() {
        this.endimator.endKeyframe();
    }

    public void resetKeyframe(int tickDuration) {
        this.endimator.resetKeyframe(tickDuration);
    }

    public void move(EndimatorModelRenderer model, float x, float y, float z) {
        this.endimator.move(model, x, y, z);
    }

    public void moveAdditive(EndimatorModelRenderer model, float x, float y, float z) {
        this.endimator.moveAdditive(model, x, y, z);
    }

    public void offset(EndimatorModelRenderer model, float x, float y, float z) {
        this.endimator.offset(model, x, y, z);
    }

    public void offsetAdditive(EndimatorModelRenderer model, float x, float y, float z) {
        this.endimator.offsetAdditive(model, x, y, z);
    }

    public void rotate(EndimatorModelRenderer model, float x, float y, float z) {
        this.endimator.rotate(model, x, y, z);
    }

    public void rotateAdditive(EndimatorModelRenderer model, float x, float y, float z) {
        this.endimator.rotateAdditive(model, x, y, z);
    }

    public void scale(EndimatorModelRenderer model, float x, float y, float z) {
        this.endimator.scale(model, x, y, z);
    }

    public void scaleAdditive(EndimatorModelRenderer model, float x, float y, float z) {
        this.endimator.scaleAdditive(model, x, y, z);
    }
}

