/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.items;

import com.github.talrey.createdeco.blocks.CatwalkBlock;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import java.util.List;
import java.util.function.Predicate;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class CatwalkBlockItem
extends BlockItem {
    private final int placementHelperID = PlacementHelpers.register((IPlacementHelper)new CatwalkHelper());

    public CatwalkBlockItem(CatwalkBlock block, Item.Properties props) {
        super((Block)block, props);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext ctx) {
        BlockPos pos = ctx.func_195995_a();
        Direction face = ctx.func_196000_l();
        World world = ctx.func_195991_k();
        PlayerEntity player = ctx.func_195999_j();
        BlockState state = world.func_180495_p(pos);
        IPlacementHelper helper = PlacementHelpers.get((int)this.placementHelperID);
        BlockRayTraceResult ray = new BlockRayTraceResult(ctx.func_221532_j(), face, pos, true);
        if (helper.matchesState(state) && player != null) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)this, player, ctx.func_221531_n(), ray);
        }
        return super.onItemUseFirst(stack, ctx);
    }

    @MethodsReturnNonnullByDefault
    public static class CatwalkHelper
    implements IPlacementHelper {
        public Predicate<ItemStack> getItemPredicate() {
            return CatwalkBlock::isCatwalk;
        }

        public Predicate<BlockState> getStatePredicate() {
            return state -> CatwalkBlock.isCatwalk(state.func_177230_c());
        }

        public PlacementOffset getOffset(PlayerEntity player, World world, BlockState state, BlockPos pos, BlockRayTraceResult ray) {
            Direction face = ray.func_216354_b();
            if (face.func_176740_k() != Direction.Axis.Y) {
                return PlacementOffset.success((Vector3i)pos.func_177971_a(face.func_176730_m()), offsetState -> (BlockState)((BlockState)((BlockState)offsetState.func_206870_a((Property)CatwalkBlock.LIFTED, state.func_177229_b((Property)CatwalkBlock.LIFTED))).func_206870_a((Property)CatwalkBlock.getPropertyFromDirection(face), (Comparable)Boolean.valueOf(!CatwalkBlock.isCatwalk(world.func_180495_p(pos.func_177971_a(face.func_176730_m()).func_177971_a(face.func_176730_m())).func_177230_c())))).func_206870_a((Property)CatwalkBlock.getPropertyFromDirection(face.func_176734_d()), (Comparable)Boolean.valueOf(false)));
            }
            List dirs = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vector3d)ray.func_216347_e(), (Direction.Axis)Direction.Axis.Y);
            for (Direction dir : dirs) {
                BlockPos newPos = pos.func_177971_a(dir.func_176730_m());
                if (!CatwalkBlock.canPlaceCatwalk(world, newPos)) continue;
                return PlacementOffset.success((Vector3i)newPos, offsetState -> (BlockState)((BlockState)((BlockState)offsetState.func_206870_a((Property)CatwalkBlock.LIFTED, state.func_177229_b((Property)CatwalkBlock.LIFTED))).func_206870_a((Property)CatwalkBlock.getPropertyFromDirection(dir), (Comparable)Boolean.valueOf(!CatwalkBlock.isCatwalk(world.func_180495_p(newPos.func_177971_a(dir.func_176730_m())).func_177230_c())))).func_206870_a((Property)CatwalkBlock.getPropertyFromDirection(dir.func_176734_d()), (Comparable)Boolean.valueOf(false)));
            }
            return PlacementOffset.fail();
        }
    }
}

