/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ToolType;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IInteractiveBlock;
import se.mickelus.tetra.compat.curios.CuriosCompat;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.items.modular.impl.toolbelt.ModularToolbeltItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.PotionsInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.QuickslotInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.QuiverInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.StorageInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.ToolbeltInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.ToolbeltSlotType;
import se.mickelus.tetra.properties.IToolProvider;
import se.mickelus.tetra.util.CastOptional;
import top.theillusivec4.curios.api.CuriosApi;

public class ToolbeltHelper {
    public static void equipItemFromToolbelt(PlayerEntity player, ToolbeltSlotType slotType, int index, Hand hand) {
        ToolbeltInventory inventory = null;
        ItemStack toolbeltStack = ToolbeltHelper.findToolbelt(player);
        if (!(toolbeltStack.func_77973_b() instanceof ModularToolbeltItem)) {
            return;
        }
        switch (slotType) {
            case quickslot: {
                inventory = new QuickslotInventory(toolbeltStack);
                break;
            }
            case potion: {
                inventory = new PotionsInventory(toolbeltStack);
                break;
            }
            case quiver: {
                inventory = new QuiverInventory(toolbeltStack);
                break;
            }
            case storage: {
                inventory = new StorageInventory(toolbeltStack);
            }
        }
        if (inventory.func_70302_i_() <= index || inventory.func_70301_a(index).func_190926_b()) {
            return;
        }
        ItemStack heldItemStack = player.func_184586_b(hand);
        player.func_184611_a(hand, inventory.takeItemStack(index));
        if (!(heldItemStack.func_190926_b() || ToolbeltHelper.storeItemInToolbelt(toolbeltStack, heldItemStack) || player.field_71071_by.func_70441_a(heldItemStack))) {
            inventory.storeItemInInventory(player.func_184586_b(hand));
            player.func_184611_a(hand, heldItemStack);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("tetra.toolbelt.blocked"), true);
        }
    }

    public static boolean storeItemInToolbelt(PlayerEntity player) {
        ItemStack toolbeltStack = ToolbeltHelper.findToolbelt(player);
        ItemStack itemStack = player.func_184586_b(Hand.OFF_HAND);
        Hand sourceHand = Hand.OFF_HAND;
        if (itemStack.func_190926_b()) {
            itemStack = player.func_184586_b(Hand.MAIN_HAND);
            sourceHand = Hand.MAIN_HAND;
        }
        if (toolbeltStack.func_190926_b() || itemStack.func_190926_b() || itemStack.func_77973_b() == ModularToolbeltItem.instance) {
            return true;
        }
        if (ToolbeltHelper.storeItemInToolbelt(toolbeltStack, itemStack)) {
            player.func_184611_a(sourceHand, ItemStack.field_190927_a);
            return true;
        }
        return false;
    }

    public static boolean storeItemInToolbelt(ItemStack toolbeltStack, ItemStack itemStack) {
        if (new PotionsInventory(toolbeltStack).storeItemInInventory(itemStack)) {
            return true;
        }
        if (new QuiverInventory(toolbeltStack).storeItemInInventory(itemStack)) {
            return true;
        }
        if (new QuickslotInventory(toolbeltStack).storeItemInInventory(itemStack)) {
            return true;
        }
        return new StorageInventory(toolbeltStack).storeItemInInventory(itemStack);
    }

    public static ItemStack findToolbelt(PlayerEntity player) {
        if (CuriosCompat.isLoaded.booleanValue()) {
            Optional maybeToolbelt = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModularToolbeltItem.instance, (LivingEntity)player);
            if (maybeToolbelt.isPresent()) {
                return (ItemStack)((ImmutableTriple)maybeToolbelt.get()).right;
            }
            if (((Boolean)ConfigHandler.toolbeltCurioOnly.get()).booleanValue()) {
                return ItemStack.field_190927_a;
            }
        }
        PlayerInventory inventoryPlayer = player.field_71071_by;
        for (int i = 0; i < inventoryPlayer.field_70462_a.size(); ++i) {
            ItemStack itemStack = inventoryPlayer.func_70301_a(i);
            if (!ModularToolbeltItem.instance.equals(itemStack.func_77973_b())) continue;
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public static List<ItemStack> getToolbeltItems(PlayerEntity player) {
        return Optional.of(ToolbeltHelper.findToolbelt(player)).filter(toolbeltStack -> !toolbeltStack.func_190926_b()).map(toolbeltStack -> {
            int i;
            QuickslotInventory quickslots = new QuickslotInventory((ItemStack)toolbeltStack);
            StorageInventory storage = new StorageInventory((ItemStack)toolbeltStack);
            ArrayList<ItemStack> result = new ArrayList<ItemStack>(quickslots.func_70302_i_() + storage.func_70302_i_());
            for (i = 0; i < quickslots.func_70302_i_(); ++i) {
                result.add(i, quickslots.func_70301_a(i));
            }
            for (i = 0; i < storage.func_70302_i_(); ++i) {
                result.add(quickslots.func_70302_i_() + i, storage.func_70301_a(i));
            }
            return result;
        }).orElse(Collections.emptyList());
    }

    public static void emptyOverflowSlots(ItemStack itemStack, PlayerEntity player) {
        new QuickslotInventory(itemStack).emptyOverflowSlots(player);
        new PotionsInventory(itemStack).emptyOverflowSlots(player);
        new StorageInventory(itemStack).emptyOverflowSlots(player);
        new QuiverInventory(itemStack).emptyOverflowSlots(player);
    }

    public static int getQuickAccessSlotIndex(PlayerEntity player, RayTraceResult traceResult, BlockState blockState) {
        ItemStack toolbeltStack = ToolbeltHelper.findToolbelt(player);
        if (toolbeltStack.func_190926_b()) {
            return -1;
        }
        QuickslotInventory inventory = new QuickslotInventory(toolbeltStack);
        List<Collection<ItemEffect>> effects = inventory.getSlotEffects();
        if (traceResult instanceof BlockRayTraceResult) {
            BlockRayTraceResult trace = (BlockRayTraceResult)traceResult;
            Vector3d hitVector = trace.func_216347_e();
            BlockPos blockPos = trace.func_216350_a();
            BlockInteraction blockInteraction = CastOptional.cast(blockState.func_177230_c(), IInteractiveBlock.class).map(block -> BlockInteraction.getInteractionAtPoint(player, blockState, blockPos, trace.func_216354_b(), (float)hitVector.field_72450_a - (float)blockPos.func_177958_n(), (float)hitVector.field_72448_b - (float)blockPos.func_177956_o(), (float)hitVector.field_72449_c - (float)blockPos.func_177952_p())).orElse(null);
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                IToolProvider providerItem;
                boolean itemCanDenail;
                ItemStack itemStack = inventory.func_70301_a(i);
                if (!effects.get(i).contains(ItemEffect.quickAccess) || itemStack.func_190926_b()) continue;
                ToolType requiredTool = blockState.getHarvestTool();
                ToolType effectiveTool = ItemModularHandheld.getEffectiveTool(blockState);
                if (requiredTool != null && itemStack.func_77973_b().getHarvestLevel(itemStack, requiredTool, player, blockState) >= blockState.getHarvestLevel() || effectiveTool != null && itemStack.func_77973_b().getToolTypes(itemStack).contains(effectiveTool)) {
                    return i;
                }
                if (ItemModularHandheld.canDenail(blockState) && (itemCanDenail = CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> item.getEffectLevel(itemStack, ItemEffect.denailing) > 0).orElse(false).booleanValue())) {
                    return i;
                }
                if (blockInteraction == null || !(itemStack.func_77973_b() instanceof IToolProvider) || (providerItem = (IToolProvider)itemStack.func_77973_b()).getToolLevel(itemStack, blockInteraction.requiredTool) < blockInteraction.requiredLevel) continue;
                return i;
            }
        }
        return -1;
    }
}

