/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.ToolTypes;
import se.mickelus.tetra.blocks.workbench.BasicWorkbenchBlock;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.effect.ChargedAbilityEffect;
import se.mickelus.tetra.gui.GuiModuleOffsets;
import se.mickelus.tetra.items.TetraItemGroup;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.data.ToolData;
import se.mickelus.tetra.module.schematic.RemoveSchematic;
import se.mickelus.tetra.module.schematic.RepairSchematic;
import se.mickelus.tetra.network.PacketHandler;
import se.mickelus.tetra.properties.AttributeHelper;

public class ModularDoubleHeadedItem
extends ItemModularHandheld {
    private static final Logger logger = LogManager.getLogger();
    public static final String headLeftKey = "double/head_left";
    public static final String headRightKey = "double/head_right";
    public static final String handleKey = "double/handle";
    public static final String bindingKey = "double/binding";
    public static final String accessoryKey = "double/accessory";
    public static final String leftSuffix = "_left";
    public static final String rightSuffix = "_right";
    private static final String unlocalizedName = "modular_double";
    private static final GuiModuleOffsets majorOffsets = new GuiModuleOffsets(-13, -1, 3, 19, -13, 19);
    private static final GuiModuleOffsets minorOffsets = new GuiModuleOffsets(6, 1);
    @ObjectHolder(value="tetra:modular_double")
    public static ModularDoubleHeadedItem instance;

    public ModularDoubleHeadedItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a((ItemGroup)TetraItemGroup.instance).func_234689_a_());
        this.setRegistryName(unlocalizedName);
        this.entityHitDamage = 2;
        this.majorModuleKeys = new String[]{headLeftKey, headRightKey, handleKey};
        this.minorModuleKeys = new String[]{bindingKey};
        this.requiredModules = new String[]{handleKey, headLeftKey, headRightKey};
        this.updateConfig((Integer)ConfigHandler.honedoubleBase.get(), (Integer)ConfigHandler.honedoubleIntegrityMultiplier.get());
        SchematicRegistry.instance.registerSchematic(new RepairSchematic(this));
        RemoveSchematic.registerRemoveSchematics(this);
    }

    public void updateConfig(int honeBase, int honeIntegrityMultiplier) {
        this.honeBase = honeBase;
        this.honeIntegrityMultiplier = honeIntegrityMultiplier;
    }

    @Override
    public void init(PacketHandler packetHandler) {
        DataManager.synergyData.onReload(() -> {
            this.synergies = DataManager.instance.getSynergyData("double/");
        });
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)this.setupHammerStack("oak", "stick"));
            items.add((Object)this.setupHammerStack("stone", "stick"));
            items.add((Object)this.setupHammerStack("iron", "spruce"));
            items.add((Object)this.setupHammerStack("blackstone", "spruce"));
            items.add((Object)this.setupHammerStack("obsidian", "iron"));
            items.add((Object)this.setupHammerStack("netherite", "forged_beam"));
        }
    }

    private ItemStack setupHammerStack(String headMaterial, String handleMaterial) {
        ItemStack itemStack = new ItemStack((IItemProvider)this);
        IModularItem.putModuleInSlot(itemStack, headLeftKey, "double/basic_hammer_left", "double/basic_hammer_left_material", "basic_hammer/" + headMaterial);
        IModularItem.putModuleInSlot(itemStack, headRightKey, "double/basic_hammer_right", "double/basic_hammer_right_material", "basic_hammer/" + headMaterial);
        IModularItem.putModuleInSlot(itemStack, handleKey, "double/basic_handle", "double/basic_handle_material", "basic_handle/" + handleMaterial);
        IModularItem.updateIdentifier(itemStack);
        return itemStack;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Hand hand = context.func_221531_n();
        if (player != null && !player.func_213453_ef() && world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150462_ai) && this.getToolLevel(player.func_184586_b(hand), ToolTypes.hammer) > 0) {
            return BasicWorkbenchBlock.upgradeWorkbench(player, world, pos, hand, context.func_196000_l());
        }
        return super.onItemUseFirst(stack, context);
    }

    @Override
    public String getDisplayNamePrefixes(ItemStack itemStack) {
        String modulePrefix = Optional.ofNullable(this.getModuleFromSlot(itemStack, headLeftKey)).map(module -> module.getItemPrefix(itemStack)).map(prefix -> prefix + " ").orElse("");
        return Arrays.stream(this.getImprovements(itemStack)).map(improvement -> improvement.key + ".prefix").filter(I18n::func_188566_a).map(x$0 -> I18n.func_135052_a((String)x$0, (Object[])new Object[0])).findFirst().map(prefix -> prefix + " " + modulePrefix).orElse(modulePrefix);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(ItemStack itemStack) {
        Multimap moduleAttributes = (Multimap)Stream.of(this.getModuleFromSlot(itemStack, headLeftKey), this.getModuleFromSlot(itemStack, headRightKey)).filter(Objects::nonNull).map(module -> module.getAttributeModifiers(itemStack)).filter(Objects::nonNull).map(modifiers -> (ArrayListMultimap)modifiers.asMap().entrySet().stream().collect(Multimaps.flatteningToMultimap(Map.Entry::getKey, entry -> AttributeHelper.collapse((Collection)entry.getValue()).stream(), ArrayListMultimap::create))).map(Multimap::entries).flatMap(Collection::stream).collect(Multimaps.toMultimap(Map.Entry::getKey, Map.Entry::getValue, ArrayListMultimap::create));
        moduleAttributes = AttributeHelper.retainMax((Multimap<Attribute, AttributeModifier>)moduleAttributes, Attributes.field_233823_f_);
        moduleAttributes = this.getAllModules(itemStack).stream().filter(itemModule -> !headLeftKey.equals(itemModule.getSlot()) && !headRightKey.equals(itemModule.getSlot())).map(module -> module.getAttributeModifiers(itemStack)).reduce(moduleAttributes, AttributeHelper::merge);
        return Arrays.stream(this.getSynergyData(itemStack)).map(synergy -> synergy.attributes).reduce(moduleAttributes, AttributeHelper::merge);
    }

    @Override
    public ToolData getToolDataRaw(ItemStack itemStack) {
        logger.debug("Gathering tool data for {} ({})", (Object)this.func_200295_i(itemStack).getString(), (Object)this.getDataCacheKey(itemStack));
        ToolData result = ToolData.retainMax(Stream.of(this.getModuleFromSlot(itemStack, headLeftKey), this.getModuleFromSlot(itemStack, headRightKey)).filter(Objects::nonNull).map(module -> module.getToolData(itemStack)).filter(Objects::nonNull).collect(Collectors.toList()));
        return Stream.concat(this.getAllModules(itemStack).stream().filter(itemModule -> !headLeftKey.equals(itemModule.getSlot()) && !headRightKey.equals(itemModule.getSlot())).map(module -> module.getToolData(itemStack)), Arrays.stream(this.getSynergyData(itemStack)).map(synergy -> synergy.tools)).filter(Objects::nonNull).reduce(result, ToolData::merge);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMajorGuiOffsets() {
        return majorOffsets;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMinorGuiOffsets() {
        return minorOffsets;
    }

    @Override
    public String getModelCacheKey(ItemStack itemStack, LivingEntity entity) {
        if (entity != null && itemStack.equals(entity.func_184607_cu())) {
            return Optional.ofNullable(this.getChargeableAbility(itemStack)).map(ChargedAbilityEffect::getModelTransform).map(transform -> super.getModelCacheKey(itemStack, entity) + ":" + transform).orElseGet(() -> super.getModelCacheKey(itemStack, entity));
        }
        return super.getModelCacheKey(itemStack, entity);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getTransformVariant(ItemStack itemStack, @Nullable LivingEntity entity) {
        ChargedAbilityEffect ability = this.getChargeableAbility(itemStack);
        if (entity != null && ability != null && itemStack.equals(entity.func_184607_cu())) {
            return ability.getModelTransform();
        }
        return null;
    }
}

