/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.generation;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.tileentity.StructureTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.StructureBlockTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.generation.FeatureChild;
import se.mickelus.tetra.generation.FeatureLoot;
import se.mickelus.tetra.generation.FeatureParameters;

@OnlyIn(value=Dist.CLIENT)
public class ExtendedStructureTESR
extends StructureTileEntityRenderer {
    public ExtendedStructureTESR(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void func_225616_a_(StructureBlockTileEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        super.func_225616_a_(te, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
        BlockPos rel = te.func_189711_e();
        Optional.ofNullable(DataManager.featureData.getData(new ResourceLocation(te.func_189715_d()))).ifPresent(feature -> this.renderFeatureInfo((FeatureParameters)feature, matrixStack, buffer, rel.func_177958_n(), rel.func_177956_o(), rel.func_177952_p()));
    }

    private void renderFeatureInfo(FeatureParameters feature, MatrixStack matrixStack, IRenderTypeBuffer buffer, double x, double y, double z) {
        IVertexBuilder vertexBuilder = buffer.getBuffer(RenderType.func_228659_m_());
        GlStateManager.func_227701_d_((float)3.0f);
        BlockPos origin = feature.origin;
        AxisAlignedBB aabb = new AxisAlignedBB(x + (double)origin.func_177958_n() + 0.5, y + (double)origin.func_177956_o() + 0.5, z + (double)origin.func_177952_p() + 0.5, x + (double)origin.func_177958_n() + 0.5, y + (double)origin.func_177956_o() + 0.5, z + (double)origin.func_177952_p() + 0.5);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)aabb.func_186662_g(0.5030000000949949), (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_186662_g(0.1), (float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)aabb.func_186662_g(0.5030000000949949), (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        Arrays.stream(feature.children).forEach(featureChild -> this.renderChild((FeatureChild)featureChild, matrixStack, buffer, (float)x, (float)y, (float)z));
        Arrays.stream(feature.loot).forEach(featureLoot -> this.renderLoot((FeatureLoot)featureLoot, matrixStack, vertexBuilder, x, y, z));
        GlStateManager.func_227701_d_((float)1.0f);
    }

    private void renderChild(FeatureChild featureChild, MatrixStack matrixStack, IRenderTypeBuffer buffer, float x, float y, float z) {
        IVertexBuilder vertexBuilder = buffer.getBuffer(RenderType.func_228659_m_());
        Tessellator tessellator = Tessellator.func_178181_a();
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        BlockPos offset = featureChild.offset;
        AxisAlignedBB aabb = new AxisAlignedBB((double)(x + (float)offset.func_177958_n()) + 0.5, (double)(y + (float)offset.func_177956_o()) + 0.5, (double)(z + (float)offset.func_177952_p()) + 0.5, (double)(x + (float)offset.func_177958_n()) + 0.5, (double)(y + (float)offset.func_177956_o()) + 0.5, (double)(z + (float)offset.func_177952_p()) + 0.5);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)aabb.func_186662_g(0.5020000000949949), (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        bufferBuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        Vector3i facing = featureChild.facing.func_176730_m();
        vertexBuilder.func_227888_a_(matrix4f, x + (float)offset.func_177958_n() + 0.5f, y + (float)offset.func_177956_o() + 0.5f, z + (float)offset.func_177952_p() + 0.5f).func_227885_a_(0.0f, 0.0f, 0.0f, 0.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix4f, x + (float)offset.func_177958_n() + 0.5f + 0.3f * (float)facing.func_177958_n(), y + (float)offset.func_177956_o() + 0.5f + 0.3f * (float)facing.func_177956_o(), z + (float)offset.func_177952_p() + 0.5f + 0.3f * (float)facing.func_177952_p()).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)aabb.func_186662_g(0.01), (float)1.0f, (float)1.0f, (float)0.0f, (float)0.5f);
        this.drawLabel("[" + offset.func_229422_x_() + "]", x + (float)offset.func_177958_n(), y + (float)offset.func_177956_o(), z + (float)offset.func_177952_p(), matrixStack, buffer, 0xF000F0);
    }

    private void renderLoot(FeatureLoot featureLoot, MatrixStack matrixStack, IVertexBuilder vertexBuilder, double x, double y, double z) {
        BlockPos offset = featureLoot.position;
        AxisAlignedBB aabb = new AxisAlignedBB(x + (double)offset.func_177958_n(), y + (double)offset.func_177956_o(), z + (double)offset.func_177952_p(), x + (double)offset.func_177958_n() + 0.2, y + (double)offset.func_177956_o() + 0.2, z + (double)offset.func_177952_p() + 0.2).func_72317_d(-0.1, -0.1, -0.1);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)aabb, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_72317_d(1.0, 0.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)aabb.func_72317_d(1.0, 0.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_72317_d(0.0, 0.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)aabb.func_72317_d(0.0, 0.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_72317_d(1.0, 0.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)aabb.func_72317_d(1.0, 0.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_72317_d(0.0, 1.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)aabb.func_72317_d(0.0, 1.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_72317_d(0.0, 1.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)aabb.func_72317_d(0.0, 1.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_72317_d(1.0, 1.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)aabb.func_72317_d(1.0, 1.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_72317_d(1.0, 1.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)aabb.func_72317_d(1.0, 1.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
    }

    protected void drawLabel(String label, float x, float y, float z, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_((double)x, (double)y, (double)z);
        matrixStackIn.func_227861_a_(0.5, (double)0.9f, 0.5);
        matrixStackIn.func_227863_a_(this.field_228858_b_.field_217666_g.func_227995_f_());
        matrixStackIn.func_227862_a_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        float f1 = Minecraft.func_71410_x().field_71474_y.func_216840_a(0.25f);
        int j = (int)(f1 * 255.0f) << 24;
        FontRenderer fontrenderer = this.field_228858_b_.field_147557_n;
        float f2 = -fontrenderer.func_78256_a(label) / 2;
        fontrenderer.func_238421_b_(matrixStackIn, label, f2, 0.0f, 0x20FFFFFF);
        fontrenderer.func_238411_a_(label, f2, 0.0f, -1, true, matrix4f, bufferIn, false, j, packedLightIn, false);
        matrixStackIn.func_227865_b_();
    }
}

