/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import se.mickelus.tetra.effect.AbilityUseResult;
import se.mickelus.tetra.effect.ChargedAbilityEffect;
import se.mickelus.tetra.effect.ComboPoints;
import se.mickelus.tetra.effect.EchoHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.potion.BleedingPotionEffect;
import se.mickelus.tetra.effect.potion.PuncturedPotionEffect;
import se.mickelus.tetra.items.modular.ItemModularHandheld;

public class PunctureEffect
extends ChargedAbilityEffect {
    public static final PunctureEffect instance = new PunctureEffect();

    PunctureEffect() {
        super(20, 0.5, 40, 8.0, ItemEffect.puncture, ChargedAbilityEffect.TargetRequirement.entity, UseAction.SPEAR, "raised");
    }

    @Override
    public void perform(PlayerEntity attacker, Hand hand, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, Vector3d hitVec, int chargedTicks) {
        if (!attacker.field_70170_p.field_72995_K) {
            int armorBefore = target.func_70658_aO();
            int comboPoints = ComboPoints.get((Entity)attacker);
            boolean isSatiated = !attacker.func_71024_bL().func_75121_c();
            AbilityUseResult result = this.isDefensive(item, itemStack, hand) ? this.performDefensive(attacker, hand, item, itemStack, target) : this.performRegular(attacker, item, itemStack, target, chargedTicks, isSatiated, comboPoints);
            boolean overextended = item.getEffectLevel(itemStack, ItemEffect.abilityOverextend) > 0;
            attacker.func_71020_j(overextended ? 6.0f : 1.0f);
            if (item.getEffectLevel(itemStack, ItemEffect.abilityExhilaration) <= 0 || armorBefore < 6 || target.func_70658_aO() >= 6) {
                attacker.func_184811_cZ().func_185145_a((Item)item, this.getCooldown(item, itemStack) + target.func_70658_aO() * 10);
            }
            item.tickProgression((LivingEntity)attacker, itemStack, result == AbilityUseResult.fail ? 1 : 2);
            int echoLevel = item.getEffectLevel(itemStack, ItemEffect.abilityEcho);
            if (echoLevel > 0) {
                this.performEcho(attacker, item, itemStack, target, chargedTicks, isSatiated, comboPoints);
            }
        }
        if (ComboPoints.canSpend(item, itemStack)) {
            ComboPoints.reset((Entity)attacker);
        }
        attacker.func_226292_a_(hand, false);
        item.applyDamage(2, itemStack, (LivingEntity)attacker);
    }

    public AbilityUseResult performRegular(PlayerEntity attacker, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, int chargedTicks, boolean isSatiated, int comboPoints) {
        int armor = target.func_70658_aO();
        AbilityUseResult result = item.hitEntity(itemStack, attacker, target, 1.0, 0.2f, 0.2f);
        if (result != AbilityUseResult.fail) {
            int momentumLevel;
            boolean reversal;
            int overchargeBonus = this.canOvercharge(item, itemStack) ? this.getOverchargeBonus(item, itemStack, chargedTicks) : 0;
            boolean isPunctured = target.func_70660_b((Effect)PuncturedPotionEffect.instance) != null;
            boolean bl = reversal = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge) > 0 && armor > attacker.func_70658_aO();
            if (armor < 6 || isPunctured || reversal) {
                int exhilarationLevel;
                double overextendEfficiency;
                double comboLevel;
                int duration = 80;
                if (overchargeBonus > 0) {
                    duration += (int)((double)overchargeBonus * item.getEffectEfficiency(itemStack, ItemEffect.abilityOvercharge) * 10.0);
                }
                if ((comboLevel = (double)item.getEffectLevel(itemStack, ItemEffect.abilityCombo)) > 0.0) {
                    duration = (int)((double)duration + comboLevel * (double)comboPoints);
                }
                if ((overextendEfficiency = item.getEffectEfficiency(itemStack, ItemEffect.abilityOverextend)) > 0.0 && isSatiated) {
                    duration = (int)((double)duration + overextendEfficiency * 20.0);
                }
                if ((exhilarationLevel = item.getEffectLevel(itemStack, ItemEffect.abilityExhilaration)) > 0 && isPunctured) {
                    duration += exhilarationLevel;
                }
                target.func_195064_c(new EffectInstance((Effect)BleedingPotionEffect.instance, duration, 1, false, false));
            }
            if (armor >= 6 && !isPunctured || reversal) {
                int overextendLevel;
                int amplifier = item.getEffectLevel(itemStack, ItemEffect.puncture) - 1;
                int duration = (int)(item.getEffectEfficiency(itemStack, ItemEffect.puncture) * 20.0);
                if (overchargeBonus > 0) {
                    amplifier += overchargeBonus * item.getEffectLevel(itemStack, ItemEffect.abilityOvercharge);
                }
                if ((overextendLevel = item.getEffectLevel(itemStack, ItemEffect.abilityOverextend)) > 0 && isSatiated) {
                    amplifier += overextendLevel;
                }
                target.func_195064_c(new EffectInstance((Effect)PuncturedPotionEffect.instance, duration, amplifier, false, false));
            }
            if (!isPunctured && (momentumLevel = item.getEffectLevel(itemStack, ItemEffect.abilityMomentum)) > 0) {
                double velocity = (double)momentumLevel / 100.0 + item.getEffectEfficiency(itemStack, ItemEffect.abilityMomentum) * (double)armor;
                target.func_70024_g(0.0, velocity *= 1.0 - target.func_233637_b_(Attributes.field_233820_c_), 0.0);
            }
            target.func_130014_f_().func_184133_a(null, target.func_233580_cy_(), SoundEvents.field_187718_dS, SoundCategory.PLAYERS, 1.0f, 0.8f);
        } else {
            target.func_130014_f_().func_184133_a(attacker, target.func_233580_cy_(), SoundEvents.field_187733_dX, SoundCategory.PLAYERS, 1.0f, 0.8f);
        }
        return result;
    }

    public AbilityUseResult performDefensive(PlayerEntity attacker, Hand hand, ItemModularHandheld item, ItemStack itemStack, LivingEntity target) {
        AbilityUseResult result;
        boolean isPunctured;
        int armor = target.func_70658_aO();
        float knockbackMultiplier = 0.3f;
        boolean bl = isPunctured = target.func_70660_b((Effect)PuncturedPotionEffect.instance) != null;
        if (armor < 6 || isPunctured) {
            knockbackMultiplier += 0.6f;
        }
        if ((result = item.hitEntity(itemStack, attacker, target, 0.3, 0.8f, knockbackMultiplier)) != AbilityUseResult.fail) {
            target.func_195064_c(new EffectInstance(Effects.field_76421_d, (int)(item.getEffectEfficiency(itemStack, ItemEffect.abilityDefensive) * 20.0), item.getEffectLevel(itemStack, ItemEffect.abilityDefensive), false, true));
            target.func_130014_f_().func_184133_a(null, target.func_233580_cy_(), SoundEvents.field_187721_dT, SoundCategory.PLAYERS, 1.0f, 0.8f);
        } else {
            target.func_130014_f_().func_184133_a(attacker, target.func_233580_cy_(), SoundEvents.field_187733_dX, SoundCategory.PLAYERS, 1.0f, 0.8f);
        }
        return result;
    }

    public void performEcho(PlayerEntity attacker, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, int chargedTicks, boolean isSatiated, int comboPoints) {
        EchoHelper.echo(attacker, 60, () -> this.performRegular(attacker, item, itemStack, target, chargedTicks, isSatiated, comboPoints));
    }
}

