/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import se.mickelus.tetra.effect.AbilityUseResult;
import se.mickelus.tetra.effect.ChargedAbilityEffect;
import se.mickelus.tetra.effect.ComboPoints;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.PryEffect;
import se.mickelus.tetra.effect.revenge.RevengeTracker;
import se.mickelus.tetra.items.modular.ItemModularHandheld;

public class PryChargedEffect
extends ChargedAbilityEffect {
    public static final PryChargedEffect instance = new PryChargedEffect();

    PryChargedEffect() {
        super(20, 0.0, 40, 3.0, ItemEffect.pry, ChargedAbilityEffect.TargetRequirement.entity, UseAction.SPEAR, "raised");
    }

    @Override
    public boolean isAvailable(ItemModularHandheld item, ItemStack itemStack) {
        return super.isAvailable(item, itemStack) && item.getEffectLevel(itemStack, ItemEffect.abilityOvercharge) > 0;
    }

    @Override
    public void perform(PlayerEntity attacker, Hand hand, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, Vector3d hitVec, int chargedTicks) {
        int revengeLevel;
        if (!target.field_70170_p.field_72995_K) {
            int amplifier = item.getEffectLevel(itemStack, ItemEffect.pry);
            double damageMultiplier = 0.5;
            int comboPoints = ComboPoints.get((Entity)attacker);
            boolean isSatiated = !attacker.func_71024_bL().func_75121_c();
            AbilityUseResult result = PryEffect.performRegular(attacker, item, itemStack, damageMultiplier += (double)(this.getOverchargeBonus(item, itemStack, chargedTicks) * item.getEffectLevel(itemStack, ItemEffect.abilityOvercharge)) / 100.0, amplifier += (int)((double)this.getOverchargeBonus(item, itemStack, chargedTicks) * item.getEffectEfficiency(itemStack, ItemEffect.abilityOvercharge)), target, isSatiated, comboPoints);
            item.tickProgression((LivingEntity)attacker, itemStack, result == AbilityUseResult.fail ? 1 : 2);
            int echoLevel = item.getEffectLevel(itemStack, ItemEffect.abilityEcho);
            if (echoLevel > 0) {
                PryEffect.performEcho(attacker, item, itemStack, damageMultiplier, amplifier, target, isSatiated, comboPoints);
            }
        }
        attacker.func_71020_j(1.0f);
        attacker.func_226292_a_(hand, false);
        attacker.func_184811_cZ().func_185145_a((Item)item, this.getCooldown(item, itemStack));
        if (ComboPoints.canSpend(item, itemStack)) {
            ComboPoints.reset((Entity)attacker);
        }
        if ((revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge)) > 0) {
            RevengeTracker.removeEnemy((Entity)attacker, (Entity)target);
        }
        item.applyDamage(2, itemStack, (LivingEntity)attacker);
    }
}

