/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.chthonic;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.blocks.forged.chthonic.ChthonicExtractorBlock;
import se.mickelus.tetra.blocks.forged.chthonic.DepletedBedrockBlock;
import se.mickelus.tetra.blocks.forged.chthonic.FracturedBedrockBlock;
import se.mickelus.tetra.blocks.forged.extractor.SeepingBedrockBlock;
import se.mickelus.tetra.util.CastOptional;

public class FracturedBedrockTile
extends TileEntity
implements ITickableTileEntity {
    @ObjectHolder(value="tetra:fractured_bedrock")
    public static TileEntityType<FracturedBedrockTile> type;
    private static final Logger logger;
    private static final String activityKey = "actv";
    private int activity = 0;
    private static final String stepKey = "step";
    private int step = 0;
    private float spawnRatio = 0.5f;
    private int spawnYLimit = 4;
    public static final Set<Material> breakMaterials;
    private static final String luckKey = "luck";
    private int luck = 0;
    private static final ResourceLocation[] lootTables;
    private MobSpawnInfo spawnInfo;

    public FracturedBedrockTile() {
        super(type);
    }

    public void updateLuck(boolean wasSeeping) {
        boolean spawnBonus;
        if (this.spawnInfo == null) {
            this.spawnInfo = this.field_145850_b.func_226691_t_(this.field_174879_c).func_242433_b();
        }
        if (spawnBonus = this.spawnInfo.func_242559_a(EntityClassification.MONSTER).stream().map(spawner -> spawner.field_242588_c).anyMatch(type -> EntityType.field_200763_C.equals(type) || EntityType.field_200750_ap.equals(type) || EntityType.field_200759_ay.equals(type))) {
            ++this.luck;
        }
        if (wasSeeping) {
            this.luck += 2;
        }
    }

    public void activate(int amount) {
        if (!this.field_145850_b.field_72995_K && this.activity <= 0) {
            this.playSound();
        }
        int preTier = this.getProjectedTier();
        this.activity += amount;
        this.func_70296_d();
        if (!this.field_145850_b.field_72995_K && this.getProjectedTier() != preTier) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    private int getRate() {
        return 20 - MathHelper.func_76125_a((int)(this.activity / 64 * 5), (int)0, (int)15);
    }

    private int getIntensity() {
        return Math.min(1 + this.activity / 16, 4);
    }

    public int getProjectedTier() {
        return this.getTier(this.step + this.activity);
    }

    private int getTier() {
        return this.getTier(this.step);
    }

    private int getTier(int ref) {
        if (ref > 10240) {
            return 3;
        }
        if (ref > 4096) {
            return 2;
        }
        if (ref > 1024) {
            return 1;
        }
        return 0;
    }

    private int getMaxDistance() {
        switch (this.getTier()) {
            case 0: {
                return 12;
            }
            case 1: {
                return 16;
            }
            case 2: {
                return 20;
            }
            case 3: {
                return 25;
            }
        }
        return 25;
    }

    private boolean shouldDeplete() {
        return this.step >= 12288;
    }

    private Vector3d getTarget(int i) {
        int maxDistance = this.getMaxDistance();
        int steps = 32;
        double directionRotation = 90.0 * (double)(i % 4);
        double offsetRotation = 360.0 / (double)steps * (double)(i / 4) + (double)((float)i / 8.0f);
        float pitch = (float)(-(i % (steps * 16)) / steps) * 5.0f;
        return Vector3d.func_189986_a((float)pitch, (float)((float)(directionRotation + offsetRotation))).func_216372_d((double)maxDistance, (double)(4.0f + (float)maxDistance / 2.0f), (double)maxDistance);
    }

    private boolean isBedrock(Block block) {
        return Blocks.field_150357_h.equals(block) || FracturedBedrockBlock.instance.equals(block) || SeepingBedrockBlock.instance.equals(block) || ChthonicExtractorBlock.instance.equals(block);
    }

    private boolean canReplace(BlockState blockState) {
        return blockState.func_185904_a().func_76222_j();
    }

    private BlockPos raytrace(Vector3d origin, Vector3d target) {
        return (BlockPos)IBlockReader.func_217300_a((RayTraceContext)new RayTraceContext(origin, target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null), (ctx, blockPos) -> {
            BlockState blockState = this.field_145850_b.func_180495_p(blockPos);
            Block block = blockState.func_177230_c();
            if (this.isBedrock(block) || this.canReplace(blockState)) {
                return null;
            }
            return blockPos.func_185334_h();
        }, ctx -> null);
    }

    private BlockPos traceDown(BlockPos blockPos) {
        BlockPos.Mutable movePos = blockPos.func_239590_i_();
        while (movePos.func_177956_o() >= 0) {
            movePos.func_189536_c(Direction.DOWN);
            BlockState blockState = this.field_145850_b.func_180495_p((BlockPos)movePos);
            if (this.isBedrock(blockState.func_177230_c())) {
                return movePos.func_189536_c(Direction.UP).func_185334_h();
            }
            if (blockState.isAir((IBlockReader)this.field_145850_b, (BlockPos)movePos)) continue;
            return movePos.func_185334_h();
        }
        return movePos.func_185334_h();
    }

    public static boolean breakBlock(World world, BlockPos pos, BlockState blockState) {
        if (world instanceof ServerWorld && !blockState.isAir((IBlockReader)world, pos) && breakMaterials.contains(blockState.func_185904_a()) && blockState.func_185887_b((IBlockReader)world, pos) > -1.0f) {
            TileEntity tile = blockState.hasTileEntity() ? world.func_175625_s(pos) : null;
            LootContext.Builder lootBuilder = new LootContext.Builder((ServerWorld)world).func_216023_a(world.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, (Object)tile).func_216021_b(LootParameters.field_216281_a, null);
            blockState.func_215693_a(lootBuilder).forEach(itemStack -> Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemStack));
            world.func_217378_a(null, 2001, pos, Block.func_196246_j((BlockState)world.func_180495_p(pos)));
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            return true;
        }
        return false;
    }

    private void spawnOre(BlockPos pos) {
        ServerWorld serverWorld = (ServerWorld)this.field_145850_b;
        LootTable table = serverWorld.func_73046_m().func_200249_aQ().func_186521_a(lootTables[this.getTier()]);
        LootContext context = new LootContext.Builder(serverWorld).func_186469_a((float)this.luck).func_216022_a(LootParameterSets.field_216260_a);
        table.func_216113_a(context).stream().filter(itemStack -> !itemStack.func_190926_b()).findAny().ifPresent(itemStack -> {
            if (itemStack.func_77973_b() instanceof BlockItem) {
                BlockState newState = ((BlockItem)itemStack.func_77973_b()).func_179223_d().func_176223_P();
                this.field_145850_b.func_217378_a(null, 2001, pos, Block.func_196246_j((BlockState)newState));
                this.field_145850_b.func_180501_a(pos, newState, 2);
            } else {
                Block.func_180635_a((World)this.field_145850_b, (BlockPos)pos, (ItemStack)itemStack);
            }
        });
    }

    private void spawnMob(BlockPos pos) {
        if (this.spawnInfo == null) {
            this.spawnInfo = this.field_145850_b.func_226691_t_(pos).func_242433_b();
        }
        if (this.func_174877_v().func_177951_i((Vector3i)pos) < 42.0 && this.field_145850_b.func_201674_k().nextFloat() >= this.spawnInfo.func_242557_a() / 5.0f) {
            return;
        }
        List spawners = this.spawnInfo.func_242559_a(EntityClassification.MONSTER);
        if (WeightedRandom.func_76272_a((List)spawners) == 0) {
            return;
        }
        MobSpawnInfo.Spawners mob = (MobSpawnInfo.Spawners)WeightedRandom.func_76271_a((Random)this.field_145850_b.func_201674_k(), (List)spawners);
        ServerWorld serverWorld = (ServerWorld)this.field_145850_b;
        if (mob.field_242588_c.func_200720_b() && serverWorld.func_226664_a_(mob.field_242588_c.func_220328_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())) && EntitySpawnPlacementRegistry.func_223515_a((EntityType)mob.field_242588_c, (IServerWorld)serverWorld, (SpawnReason)SpawnReason.SPAWNER, (BlockPos)pos, (Random)serverWorld.func_201674_k())) {
            Entity entity;
            try {
                entity = mob.field_242588_c.func_200721_a((World)serverWorld.func_201672_e());
            }
            catch (Exception exception) {
                logger.warn("Failed to create mob", (Throwable)exception);
                return;
            }
            entity.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f, 0.0f);
            CastOptional.cast(entity, MobEntity.class).filter(e -> ForgeHooks.canEntitySpawn((MobEntity)e, (IWorld)serverWorld, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), null, (SpawnReason)SpawnReason.SPAWNER) != -1).filter(e -> e.func_213380_a((IWorld)serverWorld, SpawnReason.CHUNK_GENERATION)).filter(e -> e.func_205019_a((IWorldReader)serverWorld)).ifPresent(e -> {
                e.func_213386_a((IServerWorld)serverWorld, serverWorld.func_175649_E(e.func_233580_cy_()), SpawnReason.CHUNK_GENERATION, null, null);
                serverWorld.func_242417_l((Entity)e);
                serverWorld.func_217357_a(PlayerEntity.class, new AxisAlignedBB(this.func_174877_v()).func_72314_b(24.0, 8.0, 24.0)).stream().findAny().ifPresent(arg_0 -> ((MobEntity)e).func_130011_c(arg_0));
            });
        }
    }

    private void playSound() {
        this.field_145850_b.func_184133_a(null, this.field_174879_c.func_177979_c(this.field_174879_c.func_177956_o()), SoundEvents.field_206939_L, SoundCategory.BLOCKS, 3.0f, 0.5f);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.activity > 0 && this.field_145850_b.func_82737_E() % (long)this.getRate() == 0L) {
            int intensity = this.getIntensity();
            Vector3d origin = Vector3d.func_237489_a_((Vector3i)this.func_174877_v());
            for (int i = 0; i < intensity; ++i) {
                Vector3d target = this.getTarget(this.step + i);
                BlockPos hitPos = this.raytrace(origin, origin.func_178787_e(target));
                if (hitPos == null) continue;
                BlockState blockState = this.field_145850_b.func_180495_p(hitPos);
                FracturedBedrockTile.breakBlock(this.field_145850_b, hitPos, blockState);
                BlockPos spawnPos = this.traceDown(hitPos);
                BlockState spawnState = this.field_145850_b.func_180495_p(spawnPos);
                if (this.canReplace(spawnState)) {
                    if (this.field_145850_b.func_201674_k().nextFloat() < this.spawnRatio) {
                        if (spawnPos.func_177956_o() >= this.spawnYLimit) continue;
                        this.spawnOre(spawnPos);
                        continue;
                    }
                    this.spawnMob(spawnPos);
                    continue;
                }
                FracturedBedrockTile.breakBlock(this.field_145850_b, spawnPos, spawnState);
            }
            ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, FracturedBedrockBlock.instance.func_176223_P()), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.1, (double)this.field_174879_c.func_177952_p() + 0.5, 8, 0.0, this.field_145850_b.field_73012_v.nextGaussian() * 0.1, 0.0, 0.1);
            this.step += intensity;
            this.activity -= intensity;
            if (this.shouldDeplete()) {
                this.field_145850_b.func_180501_a(this.func_174877_v(), DepletedBedrockBlock.instance.func_176223_P(), 2);
            }
        }
        if (!this.field_145850_b.field_72995_K && this.activity > 0 && this.field_145850_b.func_82737_E() % 80L == 0L) {
            this.playSound();
        }
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        super.func_230337_a_(blockState, compound);
        if (compound.func_74764_b(activityKey)) {
            this.activity = compound.func_74762_e(activityKey);
        }
        if (compound.func_74764_b(stepKey)) {
            this.step = compound.func_74762_e(stepKey);
        }
        if (compound.func_74764_b(luckKey)) {
            this.luck = compound.func_74762_e(luckKey);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a(activityKey, this.activity);
        compound.func_74768_a(stepKey, this.step);
        compound.func_74768_a(luckKey, this.luck);
        return compound;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    static {
        logger = LogManager.getLogger();
        breakMaterials = Sets.newHashSet((Object[])new Material[]{Material.field_151576_e, Material.field_151571_B, Material.field_151578_c});
        lootTables = new ResourceLocation[]{new ResourceLocation("tetra", "extractor/tier1"), new ResourceLocation("tetra", "extractor/tier2"), new ResourceLocation("tetra", "extractor/tier3"), new ResourceLocation("tetra", "extractor/tier4")};
    }
}

